/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WebBrowserPreference;

public class XDebugWebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] startStopURLs;
        IProject proj;
        Server server;
        block19: {
            if (!DaemonPlugin.getDefault().validateCommunicationDaemons("org.eclipse.php.debug.core.zendDebugger")) {
                monitor.setCanceled(true);
                monitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            if (mode.equals("debug")) {
                if (XDebugLaunchListener.getInstance().isWebLaunchActive()) {
                    this.displayErrorMessage("Web Launch Already Running");
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
                PHPLaunchUtilities.showDebugView();
            }
            if ((server = ServersManager.getServer((String)configuration.getAttribute("name", ""))) == null) {
                Logger.log(4, "Launch configuration could not find server");
                this.displayErrorMessage("Could not launch.\nInvalid server configuration.");
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            String fileName = configuration.getAttribute("file_name", null);
            Path filePath = new Path(fileName);
            proj = null;
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable t) {
                if (proj != null) break block19;
                Logger.logException("Could not execute the debug (Project is null).", t);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String project = proj.getFullPath().toString();
        wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(proj));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(proj));
        wc.doSave();
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(proj);
        stopAtFirstLine = wc.getAttribute("firstLineBreakpoint", stopAtFirstLine);
        final boolean openExternal = this.openExternal();
        final Exception[] exception = new Exception[1];
        final IWebBrowser[] browser = new IWebBrowser[1];
        if (openExternal) {
            browser[0] = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
        }
        String baseURL = new String(configuration.getAttribute("base_url", "").getBytes());
        DBGpElement target = null;
        if (mode.equals("debug")) {
            String sessionId = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            if (DBGpProxyHandler.instance.useProxy()) {
                ideKey = DBGpProxyHandler.instance.getCurrentIdeKey();
                if (!DBGpProxyHandler.instance.registerWithProxy()) {
                    this.displayErrorMessage("Unable to connect to proxy\n" + DBGpProxyHandler.instance.getErrorMsg());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            startStopURLs = this.generateStartStopDebugURLs(baseURL, sessionId, ideKey);
            String launchScript = configuration.getAttribute("file_name", null);
            if (XDebugPreferenceMgr.useMultiSession()) {
                target = new DBGpMultiSessionTarget(launch, launchScript, startStopURLs[1], ideKey, stopAtFirstLine, browser[0]);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
                launch.addDebugTarget((IDebugTarget)target);
            } else {
                target = new DBGpTarget(launch, launchScript, startStopURLs[1], ideKey, stopAtFirstLine, browser[0]);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
            }
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)((Object)target));
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = baseURL;
            startStopURLs = stringArray;
        }
        final String startURL = startStopURLs[0];
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        subMonitor.beginTask("Launching browser", 10);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    if (openExternal) {
                        browser[0].openURL(new URL(startURL));
                    } else {
                        DBGpUtils.openInternalBrowserView(startURL);
                    }
                }
                catch (Exception t) {
                    Logger.logException("Error initializing the web browser.", t);
                    exception[0] = t;
                }
            }
        });
        subMonitor.worked(10);
        if (exception[0] == null) {
            if (mode.equals("debug")) {
                launch.addDebugTarget((IDebugTarget)target);
                subMonitor.subTask("waiting for XDebug session");
                target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            } else {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
        } else {
            Logger.logException("we have an exception on the browser", exception[0]);
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)((Object)target));
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        subMonitor.done();
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)message);
            }
        });
    }

    private boolean openExternal() {
        return 1 == WebBrowserPreference.getBrowserChoice();
    }

    public String[] generateStartStopDebugURLs(String baseURL, String sessionId, String ideKey) {
        String[] startStopURLs = new String[2];
        baseURL = baseURL.indexOf("?") > -1 ? String.valueOf(baseURL) + "&" : String.valueOf(baseURL) + "?";
        startStopURLs[0] = String.valueOf(baseURL) + "XDEBUG_SESSION_START=" + ideKey + "&KEY=" + sessionId;
        startStopURLs[1] = String.valueOf(baseURL) + "XDEBUG_SESSION_STOP_NO_EXEC=" + ideKey + "&KEY=" + sessionId;
        return startStopURLs;
    }
}

