/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.dltk.console.IScriptExecResult;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsoleHistory;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ScriptExecResult;
import org.eclipse.dltk.console.ui.IScriptConsoleInput;
import org.eclipse.dltk.console.ui.IScriptConsoleListener;
import org.eclipse.dltk.console.ui.IScriptConsoleSession;
import org.eclipse.dltk.console.ui.Messages;
import org.eclipse.dltk.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.console.ui.ScriptConsoleSourceViewerConfiguration;
import org.eclipse.dltk.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleInput;
import org.eclipse.dltk.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleSession;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleViewer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.launching.process.IScriptProcess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ScriptConsole
extends TextConsole
implements ICommandHandler {
    private ILaunch launch = null;
    private ILaunchesListener2 listener = null;
    private ScriptConsolePage page;
    private ScriptConsolePartitioner partitioner;
    private IContentAssistProcessor processor;
    private ITextHover hover;
    private IScriptInterpreter interpreter;
    private ScriptConsoleSession session;
    private ListenerList consoleListeners;
    private ScriptConsolePrompt prompt;
    private ScriptConsoleHistory history;
    private boolean terminated = false;
    private ScriptConsoleViewer.ConsoleDocumentListener documentListener;
    private Set connectedProcesses;
    private List fStreamListeners = new ArrayList();

    protected void enableEdit(final ScriptConsoleViewer viewer) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                viewer.setEditable(true);
            }
        });
    }

    private void updateText(ScriptConsoleViewer viewer, final String text) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IDocument document = ScriptConsole.this.getDocument();
                String delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                ScriptConsole.this.getDocumentListener().write(String.valueOf(text) + delim, false);
            }
        });
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsolePage getPage() {
        return this.page;
    }

    public ScriptConsole(String consoleName, String consoleType, ImageDescriptor image) {
        super(consoleName, consoleType, image, true);
        this.consoleListeners = new ListenerList(1);
        this.prompt = new ScriptConsolePrompt("=>", "->");
        this.history = new ScriptConsoleHistory();
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
    }

    public ScriptConsole(String consoleName, String consoleType) {
        this(consoleName, consoleType, null);
    }

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setContentAssistProcessor(IContentAssistProcessor processor) {
        this.processor = processor;
    }

    protected void setInterpreter(IScriptInterpreter interpreter) {
        this.interpreter = interpreter;
        interpreter.addInitialListenerOperation((Runnable)new InitialStreamReader(interpreter));
    }

    public void setPrompt(ScriptConsolePrompt prompt) {
        this.prompt = prompt;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    protected void setTextHover(ITextHover hover) {
        this.hover = hover;
    }

    public ScriptConsoleViewer.ConsoleDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new ScriptConsoleViewer.ConsoleDocumentListener(this, this.getPrompt(), this.getHistory());
            this.documentListener.setDocument(this.getDocument());
        }
        return this.documentListener;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        ScriptConsoleSourceViewerConfiguration cfg = new ScriptConsoleSourceViewerConfiguration(this.processor, this.hover);
        this.page = this.createPage(view, cfg);
        return this.page;
    }

    protected ScriptConsolePage createPage(IConsoleView view, SourceViewerConfiguration cfg) {
        return new ScriptConsolePage(this, view, cfg);
    }

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    public IScriptConsoleInput getInput() {
        return new ScriptConsoleInput(this.page);
    }

    public int getState() {
        return this.interpreter.getState();
    }

    public IScriptExecResult handleCommand(String userInput) throws IOException {
        if (this.interpreter == null && this.interpreter.isValid()) {
            return new ScriptExecResult("");
        }
        Object[] listeners = this.consoleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IScriptConsoleListener)listeners[i]).userRequest(userInput);
            ++i;
        }
        IScriptExecResult output = this.interpreter.exec(userInput);
        if (this.interpreter.getState() == 0) {
            this.prompt.setMode(true);
        } else {
            this.prompt.setMode(false);
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            ((IScriptConsoleListener)listeners[i2]).interpreterResponse(output);
            ++i2;
        }
        return output;
    }

    public void executeCommand(String command) {
        this.getDocumentListener().executeCommand(command);
    }

    public void terminate() {
        block2: {
            this.terminated = true;
            try {
                this.interpreter.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.partitioner.clearRanges();
        this.terminate();
        if (this.listener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
        if (this.listener == null) {
            this.listener = new ScriptConsoleLaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.listener);
        }
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public synchronized void connect(IScriptProcess process) {
        if (this.connectedProcesses == null) {
            this.connectedProcesses = new HashSet();
        }
        if (this.connectedProcesses.add(process)) {
            IStreamsProxy proxy = process.getScriptStreamsProxy();
            if (proxy == null) {
                return;
            }
            this.connect(proxy);
        }
    }

    public void connect(IStreamsProxy proxy) {
        IStreamMonitor streamMonitor = proxy.getErrorStreamMonitor();
        if (streamMonitor != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
        }
        if ((streamMonitor = proxy.getOutputStreamMonitor()) != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(IStreamMonitor streamMonitor, String streamIdentifier) {
        IStreamMonitor iStreamMonitor = streamMonitor;
        synchronized (iStreamMonitor) {
            StreamListener listener = new StreamListener(streamIdentifier, streamMonitor);
            this.fStreamListeners.add(listener);
        }
    }

    static /* synthetic */ void access$3(ScriptConsole scriptConsole, ScriptConsoleViewer scriptConsoleViewer, String string) {
        scriptConsole.updateText(scriptConsoleViewer, string);
    }

    private final class InitialStreamReader
    implements Runnable {
        private final IScriptInterpreter interpreter;

        private InitialStreamReader(IScriptInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        public void run() {
            while (ScriptConsole.this.page == null || ScriptConsole.this.page != null && ScriptConsole.this.page.getViewer() == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            ScriptConsoleViewer viewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
            InputStream stream = this.interpreter.getInitialOutputStream();
            if (stream == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Thread readerThread = new Thread(this, reader, viewer){
                final /* synthetic */ InitialStreamReader this$1;
                private final /* synthetic */ BufferedReader val$reader;
                private final /* synthetic */ ScriptConsoleViewer val$viewer;
                {
                    this.this$1 = initialStreamReader;
                    this.val$reader = bufferedReader;
                    this.val$viewer = scriptConsoleViewer;
                }

                public void run() {
                    while (!ScriptConsole.access$0(InitialStreamReader.access$1(this.this$1))) {
                        try {
                            String readLine = this.val$reader.readLine();
                            if (readLine == null) break;
                            ScriptConsole.access$3(InitialStreamReader.access$1(this.this$1), this.val$viewer, readLine);
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break;
                            e.printStackTrace();
                            break;
                        }
                    }
                    InitialStreamReader.access$1(this.this$1).enableEdit(this.val$viewer);
                }
            };
            readerThread.start();
        }

        static /* synthetic */ ScriptConsole access$1(InitialStreamReader initialStreamReader) {
            return initialStreamReader.ScriptConsole.this;
        }
    }

    private class ScriptConsoleLaunchListener
    implements ILaunchesListener2 {
        private ScriptConsoleLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
            if (ScriptConsole.this.terminated) {
                return;
            }
            int i = 0;
            while (i < launches.length) {
                if (launches[i].equals(ScriptConsole.this.launch)) {
                    ScriptConsoleViewer consoleViewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
                    ScriptConsole.this.page.getControl().getDisplay().asyncExec(new Runnable(this, consoleViewer){
                        final /* synthetic */ ScriptConsoleLaunchListener this$1;
                        private final /* synthetic */ ScriptConsoleViewer val$consoleViewer;
                        {
                            this.this$1 = scriptConsoleLaunchListener;
                            this.val$consoleViewer = scriptConsoleViewer;
                        }

                        public void run() {
                            if (this.val$consoleViewer != null) {
                                this.val$consoleViewer.disableProcessing();
                                ScriptConsole.access$3(ScriptConsoleLaunchListener.access$1(this.this$1), this.val$consoleViewer, Messages.ScriptConsole_processTerminated);
                                this.val$consoleViewer.setEditable(false);
                            }
                        }
                    });
                }
                ++i;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        static /* synthetic */ ScriptConsole access$1(ScriptConsoleLaunchListener scriptConsoleLaunchListener) {
            return scriptConsoleLaunchListener.ScriptConsole.this;
        }
    }

    private class StreamListener
    implements IStreamListener {
        private IStreamMonitor fStreamMonitor;
        private String fStreamId;
        private boolean fFlushed = false;
        private boolean fListenerRemoved = false;

        public StreamListener(String streamIdentifier, IStreamMonitor monitor) {
            this.fStreamId = streamIdentifier;
            this.fStreamMonitor = monitor;
            this.fStreamMonitor.addListener((IStreamListener)this);
            this.streamAppended(null, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(String text, IStreamMonitor monitor) {
            if (this.fFlushed) {
                ScriptConsole.this.getDocumentListener().write(text, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM".equals(this.fStreamId));
            } else {
                String contents = null;
                IStreamMonitor iStreamMonitor = this.fStreamMonitor;
                synchronized (iStreamMonitor) {
                    this.fFlushed = true;
                    contents = this.fStreamMonitor.getContents();
                    if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                        IFlushableStreamMonitor m = (IFlushableStreamMonitor)this.fStreamMonitor;
                        m.flushContents();
                        m.setBuffered(false);
                    }
                }
                if (contents != null && contents.length() > 0) {
                    ScriptConsole.this.getDocumentListener().write(contents, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM".equals(this.fStreamId));
                }
            }
        }

        public IStreamMonitor getStreamMonitor() {
            return this.fStreamMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream() {
            if (this.fStreamMonitor == null) {
                return;
            }
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                this.fStreamMonitor.removeListener((IStreamListener)this);
                if (!this.fFlushed) {
                    String contents = this.fStreamMonitor.getContents();
                    this.streamAppended(contents, this.fStreamMonitor);
                }
                this.fListenerRemoved = true;
            }
        }

        public void dispose() {
            if (!this.fListenerRemoved) {
                this.closeStream();
            }
            this.fStreamMonitor = null;
            this.fStreamId = null;
        }
    }
}

