/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.ThemeButtonDrawInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    Image image;
    int cIcon;
    boolean isImage;
    boolean grayed;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        this.postEvent(13);
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        int[] context = null;
        if ((this.style & 4) != 0) {
            boolean invert = false;
            if (OS.VERSION < 4176) {
                invert = (this.style & 0x80) != 0;
            } else {
                boolean bl = invert = (this.style & 0x80) != 0 || (this.style & 0x4000) != 0;
            }
            if (invert) {
                context = new int[1];
                OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
                OS.CGContextSaveGState(context[0]);
                CGRect rect = new CGRect();
                OS.HIViewGetBounds(this.handle, rect);
                OS.CGContextRotateCTM(context[0], (float)Compatibility.PI);
                OS.CGContextTranslateCTM(context[0], -rect.width, -rect.height);
            }
        }
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (context != null) {
            OS.CGContextRestoreGState(context[0]);
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int[] outMetric;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] outMetric2 = new int[1];
            OS.GetThemeMetric(25, outMetric2);
            int width = outMetric2[0];
            int height = outMetric2[0];
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        int width = 0;
        int height = 0;
        if (this.isImage && this.image != null) {
            Rectangle bounds = this.image.getBounds();
            width = bounds.width;
            height = bounds.height;
        }
        int[] ptr = new int[1];
        OS.CopyControlTitleAsCFString(this.handle, ptr);
        if (ptr[0] != 0) {
            Point size = this.textExtent(ptr[0], 0);
            width += size.x;
            height = Math.max(height, size.y);
            OS.CFRelease(ptr[0]);
            if (this.image != null && this.isImage) {
                width += 3;
            }
        } else if (this.image == null) {
            width = 64;
            height = 64;
        }
        if ((this.style & 0x30) != 0) {
            outMetric = new int[1];
            int metric = (this.style & 0x20) != 0 ? 50 : 52;
            OS.GetThemeMetric(metric, outMetric);
            width += outMetric[0] + 3;
            height = Math.max(outMetric[0], height);
        } else if ((this.style & 0x800000) != 0 || (this.style & 2) != 0) {
            width += 8;
            height += 8;
        } else {
            width += 28;
            outMetric = new int[1];
            OS.GetThemeMetric(19, outMetric);
            height = Math.max(height, outMetric[0]);
        }
        Rect inset = this.getInset();
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        width = Math.max(20, width);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x800;
        }
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        if ((this.style & 4) != 0) {
            int orientation = 0;
            if ((this.style & 0x80) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x400) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x4000) != 0) {
                orientation = 2;
            }
            OS.CreateBevelButtonControl(window, null, 0, (short)0, (short)0, 0, (short)0, (short)0, (short)0, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{6});
            OS.SetControl32BitMaximum(this.handle, 2);
            OS.SetControl32BitValue(this.handle, orientation);
        }
        if ((this.style & 0x20) != 0) {
            OS.CreateBevelButtonControl(window, null, 0, (short)0, (short)256, 0, (short)0, (short)0, (short)0, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{1});
        }
        if ((this.style & 0x10) != 0) {
            OS.CreateBevelButtonControl(window, null, 0, (short)0, (short)256, 0, (short)0, (short)0, (short)0, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{2});
        }
        if ((this.style & 2) != 0) {
            OS.CreateBevelButtonControl(window, null, 0, (short)1, (short)256, 0, (short)0, (short)0, (short)0, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{15});
            }
        }
        if ((this.style & 8) != 0) {
            if ((this.style & 0x800000) != 0) {
                OS.CreateBevelButtonControl(window, null, 0, (short)2, (short)0, 0, (short)0, (short)0, (short)0, outControl);
            } else {
                OS.CreatePushButtonControl(window, null, 0, outControl);
            }
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData(this.handle, 0, 1650811499, 2, new short[1]);
            }
        }
        ControlFontStyleRec fontRec = new ControlFontStyleRec();
        fontRec.flags = (short)128;
        fontRec.font = (short)this.defaultThemeFont();
        OS.SetControlFontStyle(this.handle, fontRec);
        if ((this.style & 4) != 0) {
            return;
        }
        this._setAlignment(this.style & 0x1024000);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 105;
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        if (OS.VERSION < 4160 && this.isImage && this.image != null && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            Rect bounds = new Rect();
            Rect content = new Rect();
            OS.GetControlBounds(this.handle, bounds);
            ThemeButtonDrawInfo drawInfo = new ThemeButtonDrawInfo();
            drawInfo.state = OS.IsControlEnabled(this.handle) ? (OS.IsControlActive(this.handle) ? 1 : 0) : (OS.IsControlActive(this.handle) ? 7 : 8);
            drawInfo.adornment = 1;
            OS.GetThemeButtonContentBounds(bounds, 0, drawInfo, content);
            int width = this.image == null ? 0 : OS.CGImageGetWidth(this.image.handle);
            int height = this.image == null ? 0 : OS.CGImageGetHeight(this.image.handle);
            int x = (bounds.right - bounds.left - width) / 2;
            int y = (content.bottom - content.top - height) / 2;
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            GC gc = GC.carbon_new(this, data);
            gc.drawImage(this.image, x, y);
            gc.dispose();
        }
        super.drawWidget(control, context, damageRgn, visibleRgn, theEvent);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.GetControl32BitValue(this.handle) != 0;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    Rect getInset() {
        if ((this.style & 8) == 0) {
            return super.getInset();
        }
        return this.display.buttonInset;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        if ((this.style & 0x10) != 0) {
            int[] stringRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
            int length = 0;
            if (stringRef[0] != 0) {
                length = OS.CFStringGetLength(stringRef[0]);
            }
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(stringRef[0], range, buffer);
            String attributeName = new String(buffer);
            if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
                String roleText = "AXRadioButton";
                buffer = new char[roleText.length()];
                roleText.getChars(0, buffer.length, buffer, 0);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    if (attributeName.equals("AXRole")) {
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    } else {
                        int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                        OS.CFRelease(stringRef2);
                    }
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            }
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) == 0) {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            switch (OS.GetControl32BitValue(this.handle)) {
                case 0: {
                    OS.SetControl32BitMaximum(this.handle, 2);
                    OS.SetControl32BitValue(this.handle, 2);
                    break;
                }
                case 1: 
                case 2: {
                    OS.SetControl32BitMaximum(this.handle, 0);
                    OS.SetControl32BitValue(this.handle, 0);
                }
            }
        }
        this.postEvent(13);
        return -9874;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
        this.redraw();
    }

    void _setAlignment(int alignment) {
        boolean bothVisible;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            int orientation = 0;
            if ((this.style & 0x80) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x400) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x4000) != 0) {
                orientation = 2;
            }
            OS.SetControl32BitValue(this.handle, orientation);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = bothVisible = this.text != null && this.text.length() > 0 && this.image != null;
        if (bothVisible) {
            if ((this.style & 0x30) != 0) {
                alignment = 16384;
            }
            if ((this.style & 0xA) != 0) {
                alignment = 0x1000000;
            }
        }
        int textAlignment = 0;
        int graphicAlignment = 0;
        if ((alignment & 0x4000) != 0) {
            textAlignment = -2;
            graphicAlignment = 1;
        }
        if ((alignment & 0x1000000) != 0) {
            textAlignment = 1;
            graphicAlignment = 0;
        }
        if ((alignment & 0x20000) != 0) {
            textAlignment = -1;
            graphicAlignment = 2;
        }
        OS.SetControlData(this.handle, 0, 1952541801, 2, new short[]{(short)textAlignment});
        OS.SetControlData(this.handle, 0, 1734437993, 2, new short[]{(short)graphicAlignment});
        if (bothVisible) {
            OS.SetControlData(this.handle, 0, 1953524835, 2, new short[]{1});
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        if (resize && (this.style & 4) == 0) {
            height = Math.max(20, height);
        }
        return super.setBounds(x, y, width, height, move, resize, events);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        int window = OS.GetControlOwner(this.handle);
        OS.SetWindowDefaultButton(window, value ? this.handle : 0);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        if (grayed) {
            if (OS.GetControl32BitValue(this.handle) != 0) {
                OS.SetControl32BitMaximum(this.handle, 2);
                OS.SetControl32BitValue(this.handle, 2);
            } else {
                OS.SetControl32BitMaximum(this.handle, 0);
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            if (OS.GetControl32BitValue(this.handle) != 0) {
                OS.SetControl32BitValue(this.handle, 1);
            }
            OS.SetControl32BitMaximum(this.handle, 1);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
        this.image = image;
        this.isImage = true;
        if (OS.VERSION < 4160 && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            if (image == null) {
                this.setText(this.text);
                return;
            }
            if (this.text.length() > 0) {
                int ptr = OS.CFStringCreateWithCharacters(0, null, 0);
                if (ptr == 0) {
                    this.error(13);
                }
                OS.SetControlTitleWithCFString(this.handle, ptr);
                OS.CFRelease(ptr);
            }
        }
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image != null) {
            if (OS.VERSION < 4160) {
                this.cIcon = this.createCIcon(image);
                inContent.contentType = (short)130;
                inContent.iconRef = this.cIcon;
            } else {
                inContent.contentType = (short)134;
                inContent.iconRef = image.handle;
            }
        } else {
            inContent.contentType = 0;
        }
        OS.SetBevelButtonContentInfo(this.handle, inContent);
        this._setAlignment(this.style);
        this.redraw();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        if ((this.style & 0x20) != 0) {
            if (this.grayed) {
                if (selected) {
                    OS.SetControl32BitMaximum(this.handle, 2);
                    OS.SetControl32BitValue(this.handle, 2);
                } else {
                    OS.SetControl32BitMaximum(this.handle, 0);
                    OS.SetControl32BitValue(this.handle, 0);
                }
                return;
            }
            OS.SetControl32BitMaximum(this.handle, 1);
        }
        OS.SetControl32BitValue(this.handle, selected ? 1 : 0);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        if (OS.VERSION < 4160 && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            if (this.isImage) {
                ControlButtonContentInfo inContent = new ControlButtonContentInfo();
                inContent.contentType = 0;
                OS.SetBevelButtonContentInfo(this.handle, inContent);
            }
            this.isImage = false;
        }
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlTitleWithCFString(this.handle, ptr);
        OS.CFRelease(ptr);
        this._setAlignment(this.style);
        this.redraw();
    }

    int traversalCode(int key, int theEvent) {
        int code = super.traversalCode(key, theEvent);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

