/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.php.core.codeassist.FakeGroupMethod;
import org.eclipse.php.core.codeassist.FakeGroupType;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.documentation.BuiltinDoc;
import org.eclipse.wst.sse.core.internal.Logger;

public class PHPDocumentationProvider
implements IScriptDocumentationProvider {
    private static final String DL_END = "</dl>";
    private static final String DL_START = "<dl>";
    private static final String DD_END = "</dd>";
    private static final String DD_START = "<dd>";
    private static final String DT_START = "<dt>";
    private static final String DT_END = "</dt>";
    private static final String FIELD_LOCATION = "Location";
    private static final String FIELD_AUTHOR = "Author";
    private static final String FIELD_CLASS = "Class";
    private static final String FIELD_DESC = "Description";
    private static final String FIELD_PARAMETERS = "Parameters";
    private static final String FIELD_RETURNS = "Returns";
    private static final String FIELD_THROWS = "Throws";
    private static final String FIELD_DEPRECATED = "Deprecated";
    private static final String FIELD_SEEALSO = "See Also";
    private static final String FIELD_EXTENDS = "Extends";
    private static final String FIELD_IMPLEMENTS = "Implements";

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        StringBuilder buf = new StringBuilder(DL_START);
        try {
            if (!this.appendBuiltinDoc(element, buf)) {
                if (element instanceof IMethod) {
                    this.appendMethodInfo((IMethod)element, buf);
                } else if (element instanceof IType) {
                    this.appendTypeInfo((IType)element, buf);
                } else if (element instanceof IField) {
                    this.appendFieldInfo((IField)element, buf);
                }
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        buf.append(DL_END);
        return new StringReader(buf.toString());
    }

    public Reader getInfo(String keyword) {
        String builtinDoc = BuiltinDoc.getString(keyword);
        if (builtinDoc.length() > 0) {
            StringBuilder buf = new StringBuilder(DL_START);
            buf.append(builtinDoc);
            buf.append(DL_END);
            return new StringReader(buf.toString());
        }
        return null;
    }

    private boolean appendBuiltinDoc(IMember element, StringBuilder buf) {
        String builtinDoc = BuiltinDoc.getString(element.getElementName());
        if (builtinDoc.length() > 0) {
            ISourceModule sourceModule = element.getSourceModule();
            String fileName = sourceModule.getElementName();
            PHPDocumentationProvider.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
            IType declaringType = element.getDeclaringType();
            if (declaringType != null) {
                PHPDocumentationProvider.appendDefinitionRow(FIELD_CLASS, declaringType.getElementName(), buf);
            }
            buf.append(builtinDoc);
            return true;
        }
        return false;
    }

    private void appendMethodInfo(IMethod method, StringBuilder buf) throws ModelException {
        ModuleDeclaration module;
        MethodDeclaration methodDeclaration;
        if (method instanceof FakeGroupMethod) {
            PHPDocumentationProvider.appendDefinitionRow(FIELD_DESC, "This is a group containing multiple functions.", buf);
            return;
        }
        ISourceModule sourceModule = method.getSourceModule();
        String fileName = sourceModule.getElementName();
        PHPDocumentationProvider.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        IType declaringType = method.getDeclaringType();
        if (declaringType != null) {
            PHPDocumentationProvider.appendDefinitionRow(FIELD_CLASS, declaringType.getElementName(), buf);
        }
        if (!((methodDeclaration = PHPModelUtils.getNodeByMethod((ModuleDeclaration)(module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule)), (IMethod)method)) instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc();
        if (doc == null) {
            return;
        }
        PHPDocumentationProvider.appendShortDescription(doc, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 7, FIELD_PARAMETERS, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 6, FIELD_RETURNS, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 29, FIELD_THROWS, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 8, FIELD_SEEALSO, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 2, FIELD_DEPRECATED, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 1, FIELD_AUTHOR, buf);
    }

    private void appendTypeInfo(IType type, StringBuilder buf) throws ModelException {
        if (type instanceof FakeGroupType) {
            PHPDocumentationProvider.appendDefinitionRow(FIELD_DESC, "This is a group containing multiple classes or interfaces.", buf);
            return;
        }
        ISourceModule sourceModule = type.getSourceModule();
        String fileName = sourceModule.getElementName();
        PHPDocumentationProvider.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass((ModuleDeclaration)module, (IType)type);
        if (typeDeclaration instanceof ClassDeclaration) {
            String[] interfaceNames;
            ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
            String superClassName = classDeclaration.getSuperClassName();
            if (superClassName != null) {
                PHPDocumentationProvider.appendDefinitionRow(FIELD_EXTENDS, superClassName, buf);
            }
            if ((interfaceNames = classDeclaration.getInterfaceNames()) != null) {
                PHPDocumentationProvider.appendDefinitionRows(FIELD_IMPLEMENTS, interfaceNames, buf);
            }
        } else {
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null) {
                PHPDocumentationProvider.appendDefinitionRows(FIELD_EXTENDS, superClassNames, buf);
            }
        }
        if (!(typeDeclaration instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc();
        if (doc == null) {
            return;
        }
        PHPDocumentationProvider.appendShortDescription(doc, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 8, FIELD_SEEALSO, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 2, FIELD_DEPRECATED, buf);
        PHPDocumentationProvider.appendTagInfo(doc, 1, FIELD_AUTHOR, buf);
    }

    private void appendFieldInfo(IField field, StringBuilder buf) throws ModelException {
        ModuleDeclaration module;
        ASTNode node;
        ISourceModule sourceModule = field.getSourceModule();
        String fileName = sourceModule.getElementName();
        PHPDocumentationProvider.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        IType declaringType = field.getDeclaringType();
        if (declaringType != null) {
            PHPDocumentationProvider.appendDefinitionRow(FIELD_CLASS, declaringType.getElementName(), buf);
        }
        if (!((node = PHPModelUtils.getNodeByField((ModuleDeclaration)(module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule)), (IField)field)) instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)node).getPHPDoc();
        if (doc == null) {
            return;
        }
        PHPDocumentationProvider.appendShortDescription(doc, buf);
    }

    private static String nl2br(String str) {
        return str.replaceAll("\\n", "<br>");
    }

    private static void appendDefinitionRow(String field, String data, StringBuilder buf) {
        buf.append(DT_START).append(field).append(DT_END);
        buf.append(DD_START).append(data).append(DD_END);
    }

    private static void appendDefinitionRows(String field, String[] data, StringBuilder buf) {
        buf.append(DT_START).append(field).append(DT_END);
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            buf.append(DD_START).append(row).append(DD_END);
            ++n2;
        }
    }

    private static void appendShortDescription(PHPDocBlock doc, StringBuilder buf) {
        String desc = doc.getShortDescription();
        if (desc != null && desc.length() > 0) {
            PHPDocumentationProvider.appendDefinitionRow(FIELD_DESC, PHPDocumentationProvider.nl2br(desc), buf);
        }
    }

    private static void appendTagInfo(PHPDocBlock doc, int tagKind, String field, StringBuilder buf) {
        PHPDocTag[] tags = PHPDocumentationProvider.getTags(doc, tagKind);
        if (tags.length > 0) {
            buf.append(DT_START).append(field).append(DT_END);
            PHPDocTag[] pHPDocTagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                buf.append(DD_START).append(tag.getValue()).append(DD_END);
                ++n2;
            }
        }
    }

    private static PHPDocTag[] getTags(PHPDocBlock doc, int kind) {
        LinkedList<PHPDocTag> tags = new LinkedList<PHPDocTag>();
        PHPDocTag[] pHPDocTagArray = doc.getTags();
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            if (tag.getTagKind() == kind) {
                tags.add(tag);
            }
            ++n2;
        }
        return tags.toArray(new PHPDocTag[tags.size()]);
    }
}

