/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.ASTNodes;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    public static final SharedASTProvider.WAIT_FLAG WAIT_YES = SharedASTProvider.WAIT_YES;
    public static final SharedASTProvider.WAIT_FLAG WAIT_ACTIVE_ONLY = SharedASTProvider.WAIT_ACTIVE_ONLY;
    public static final SharedASTProvider.WAIT_FLAG WAIT_NO = SharedASTProvider.WAIT_NO;
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    public static final String SHARED_AST_LEVEL = "php5";
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private ISourceModule fReconcilingPhpElement;
    private ISourceModule fActivePhpElement;
    private Program fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return PHPUiPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activePhpEditorChanged(IWorkbenchPart editor) {
        IModelElement inputModelElement;
        ISourceModule phpElement = null;
        if (editor instanceof PHPStructuredEditor && (inputModelElement = ((PHPStructuredEditor)editor).getModelElement()) != null && inputModelElement.getElementType() == 5) {
            phpElement = (ISourceModule)inputModelElement;
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActivePhpElement = phpElement;
            this.cache(null, phpElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(phpElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingPhpElement == null || !this.fReconcilingPhpElement.equals(phpElement))) {
                this.fIsReconciling = false;
                this.fReconcilingPhpElement = null;
            } else if (phpElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingPhpElement = null;
            }
        }
    }

    public boolean isCached(Program ast) {
        return ast != null && this.fAST == ast;
    }

    public boolean isActive(ISourceModule cu) {
        return cu != null && cu.equals(this.fActivePhpElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(ISourceModule phpElement) {
        if (phpElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(phpElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingPhpElement = phpElement;
        }
        this.cache(null, phpElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActivePhpElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(ISourceModule phpElement) {
        if (phpElement == null) {
            return "null";
        }
        return phpElement.getElementName();
    }

    private String toString(Program ast) {
        if (ast == null) {
            return "null";
        }
        return ast.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(Program ast, ISourceModule phpElement) {
        if (this.fActivePhpElement != null && !this.fActivePhpElement.equals(phpElement)) {
            if (DEBUG && phpElement != null) {
                System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(phpElement));
            }
            return;
        }
        if (DEBUG && (phpElement != null || ast != null)) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(ast) + " for: " + this.toString(phpElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Program getAST(ISourceModule input, SharedASTProvider.WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) throws ModelException, IOException {
        boolean isActiveElement;
        if (input == null) throw new IllegalArgumentException("input or wait flag are null");
        if (waitFlag == null) {
            throw new IllegalArgumentException("input or wait flag are null");
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = input.equals(this.fActivePhpElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
                if (waitFlag == SharedASTProvider.WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + input.getElementName());
                    return null;
                }
            }
        }
        if (isActiveElement && this.isReconciling(input)) {
            try {
                ISourceModule activeElement = this.fReconcilingPhpElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + input.getElementName());
                    }
                    this.fWaitLock.wait();
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActivePhpElement) return this.getAST(input, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(input, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST for: " + input.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (waitFlag == SharedASTProvider.WAIT_NO) return null;
        if (waitFlag == SharedASTProvider.WAIT_ACTIVE_ONLY) {
            if (!isActiveElement) return null;
            if (this.fAST != null) {
                return null;
            }
        }
        if (isActiveElement) {
            this.aboutToBeReconciled(input);
        }
        Program ast = null;
        try {
            ast = ASTProvider.createAST(input, progressMonitor);
            if (progressMonitor == null) return ast;
            if (!progressMonitor.isCanceled()) return ast;
            ast = null;
            if (!DEBUG) return ast;
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + input.getElementName() + " - AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, input, null);
                    return this.fAST;
                }
                this.reconciled(ast, input, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(ISourceModule phpElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return phpElement != null && phpElement.equals(this.fReconcilingPhpElement) && this.fIsReconciling;
        }
    }

    private static Program createAST(final ISourceModule input, final IProgressMonitor progressMonitor) throws ModelException, IOException {
        if (!ASTProvider.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((String)SHARED_AST_LEVEL, (ISourceModule)input);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final Program[] root = new Program[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    if (DEBUG) {
                        System.err.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "creating AST for: " + input.getElementName());
                    }
                    root[0] = parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], 4);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.php.ui", 0, "Error in JDT Core during AST creation", ex);
                PHPUiPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }

    private static boolean hasSource(ISourceModule je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je.getBuffer() != null;
        }
        catch (ModelException modelException) {
            PHPUiPlugin.logErrorMessage("Error in PDT Core during AST creation");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().removePartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(Program ast, ISourceModule phpElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(phpElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            boolean bl = this.fIsReconciling = progressMonitor != null && progressMonitor.isCanceled();
            if (phpElement == null || !phpElement.equals(this.fReconcilingPhpElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, phpElement);
        }
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener,
    IPerspectiveListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activePhpEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isPhpEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activePhpEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isPhpEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            ref.getId();
            return true;
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            IWorkbenchPartReference ref = page.getActivePartReference();
            if (this.isPhpEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activePhpEditorChanged(ref.getPart(true));
            }
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    }
}

