/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.Vector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PHPOutlineContentProvider
implements ITreeContentProvider {
    private TreeViewer fOutlineViewer;
    private ElementChangedListener fListener;

    public PHPOutlineContentProvider(TreeViewer viewer) {
        this.fOutlineViewer = viewer;
        this.fOutlineViewer.setAutoExpandLevel(-1);
        this.inputChanged((Viewer)this.fOutlineViewer, null, null);
    }

    public void dispose() {
        if (this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    protected IModelElement[] filter(IModelElement[] children) {
        boolean initializers = false;
        int i = 0;
        while (i < children.length) {
            if (this.matches(children[i])) {
                initializers = true;
                break;
            }
            ++i;
        }
        if (!initializers) {
            return children;
        }
        Vector<IModelElement> v = new Vector<IModelElement>();
        int i2 = 0;
        while (i2 < children.length) {
            if (!this.matches(children[i2])) {
                v.addElement(children[i2]);
            }
            ++i2;
        }
        Object[] result = new IModelElement[v.size()];
        v.copyInto(result);
        return result;
    }

    public Object[] getChildren(Object parent) {
        block3: {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    return this.filter(c.getChildren());
                }
                catch (ModelException x) {
                    if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return PHPContentOutlineConfiguration.NO_CHILDREN;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof IModelElement) {
            IModelElement e = (IModelElement)child;
            return e.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        block3: {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    IModelElement[] children = this.filter(c.getChildren());
                    return children != null && children.length > 0;
                }
                catch (ModelException x) {
                    if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block3;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isCU = newInput instanceof ISourceModule;
        if (isCU && this.fListener == null) {
            this.fListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
        } else if (!isCU && this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    public boolean isDeleted(Object o) {
        return false;
    }

    protected boolean matches(IModelElement element) {
        if (element.getElementType() == 9) {
            String name = element.getElementName();
            return name != null && name.indexOf(60) >= 0;
        }
        if (element.getElementType() == 8) {
            IField field = (IField)element;
            try {
                if ((field.getFlags() & 4) != 0) {
                    return false;
                }
            }
            catch (ModelException modelException) {}
            return element.getParent().getElementType() != 7;
        }
        return false;
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        protected ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            Control control = PHPOutlineContentProvider.this.fOutlineViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            Display d = control.getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(){

                    public void run() {
                        IModelElement base;
                        IModelElementDelta delta;
                        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (activeEditor instanceof PHPStructuredEditor && (delta = ElementChangedListener.this.findElement(base = ((PHPStructuredEditor)activeEditor).getModelElement(), e.getDelta())) != null && PHPOutlineContentProvider.this.fOutlineViewer != null) {
                            PHPOutlineContentProvider.this.fOutlineViewer.refresh();
                        }
                    }
                });
            }
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }
    }
}

