/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class PHPTemplateStore
extends ContributionTemplateStore {
    public PHPTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    public void add(TemplatePersistenceData data) {
        Template template = data.getTemplate();
        if (template.getName().equals("")) {
            String title = PHPUIMessages.getString("PHPTemplateStore_error_title");
            String message = PHPUIMessages.getString("PHPTemplateStore_error_message_nameEmpty");
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            return;
        }
        super.add(data);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template) {
        String string = null;
        int offset = 0;
        if (template != null) {
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextTypeRegistry.getContextType(template.getContextTypeId()), (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                string = buffer.getString();
                TemplateVariable[] variables = buffer.getVariables();
                int i = 0;
                while (i != variables.length) {
                    TemplateVariable variable = variables[i];
                    if ("cursor".equals(variable.getName())) {
                        offset = variable.getOffsets()[0];
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.log(202, "Could not create template for new PHP", e);
            }
        }
        return new CompiledTemplate(string, offset);
    }

    public static class CompiledTemplate {
        public final String string;
        public final int offset;

        public CompiledTemplate(String string, int offset) {
            this.string = string;
            this.offset = offset;
        }
    }
}

