/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

public class GlobalVariableOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "GlobalVariableOccurrencesFinder";
    private String globalName;
    private boolean isGlobalScope;

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.isGlobalScope = true;
        if (node.getType() == 51) {
            this.globalName = ((Scalar)node).getStringValue();
            if (this.globalName.length() > 2 && this.isQuated(this.globalName)) {
                this.globalName = this.globalName.substring(1, this.globalName.length() - 1);
            }
            return null;
        }
        if (node.getType() == 33) {
            this.globalName = ((Identifier)node).getName();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, String.valueOf('$') + this.globalName);
        this.fASTRoot.accept((Visitor)this);
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        this.setGlobalScope(false);
        return true;
    }

    public void endVisit(ClassDeclaration classDeclaration) {
        this.setGlobalScope(true);
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        this.setGlobalScope(false);
        return true;
    }

    public void endVisit(FunctionDeclaration functionDeclaration) {
        this.setGlobalScope(true);
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.setGlobalScope(false);
        return true;
    }

    public void endVisit(InterfaceDeclaration interfaceDeclaration) {
        this.setGlobalScope(true);
    }

    public boolean visit(FieldsDeclaration fieldDeclaration) {
        this.setGlobalScope(false);
        return true;
    }

    public void endVisit(FieldsDeclaration fieldsDeclaration) {
        this.setGlobalScope(true);
    }

    public boolean visit(Variable variable) {
        if (variable.isDollared() && variable.getName().getType() == 33) {
            Identifier identifier = (Identifier)variable.getName();
            if (this.isGlobalScope && this.globalName.equals(identifier.getName())) {
                this.addOccurrence((ASTNode)variable);
            }
        }
        return true;
    }

    public boolean visit(Scalar scalar) {
        VariableBase variableName;
        ASTNode parent;
        String stringValue = scalar.getStringValue();
        if (stringValue.length() > 2 && this.isQuated(stringValue)) {
            stringValue = stringValue.substring(1, stringValue.length() - 1);
        }
        if (this.globalName.equals(stringValue) && (parent = scalar.getParent()).getType() == 0 && (variableName = ((ArrayAccess)parent).getName()).getType() == 60) {
            Identifier id;
            Variable var = (Variable)variableName;
            Expression varName = var.getName();
            if (var.isDollared() && varName.getType() == 33 && (id = (Identifier)varName).getName().equals("GLOBALS")) {
                this.addOccurrence((ASTNode)scalar);
            }
        }
        return true;
    }

    public boolean visit(GlobalStatement globalStatement) {
        List variables = globalStatement.variables();
        for (Variable variable : variables) {
            Identifier identifier;
            if (!variable.isDollared() || !this.globalName.equals((identifier = (Identifier)variable.getName()).getName())) continue;
            this.addOccurrence((ASTNode)variable);
            this.setGlobalScope(true);
        }
        return true;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        VariableBase variableName = arrayAccess.getName();
        if (variableName.getType() == 60) {
            Scalar scalar;
            String stringValue;
            Expression index;
            Identifier id;
            Variable var = (Variable)variableName;
            Expression varName = var.getName();
            if (var.isDollared() && varName.getType() == 33 && (id = (Identifier)varName).getName().equals("GLOBALS") && (index = arrayAccess.getIndex()) != null && index.getType() == 51 && (stringValue = (scalar = (Scalar)index).getStringValue()).length() > 2 && this.isQuated(stringValue) && this.globalName.equals(stringValue.substring(1, stringValue.length() - 1))) {
                this.addOccurrence((ASTNode)scalar);
            }
        }
        return true;
    }

    private boolean isQuated(String stringValue) {
        char first = stringValue.charAt(0);
        char last = stringValue.charAt(stringValue.length() - 1);
        return first == '\'' && last == '\'' || first == '\"' && last == '\"';
    }

    private void addOccurrence(ASTNode node) {
        int readWriteType = this.getOccurrenceType(node);
        String desc = this.fDescription;
        if (readWriteType == 1) {
            desc = Messages.format(BASE_WRITE_DESCRIPTION, String.valueOf('$') + this.globalName);
        }
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), readWriteType, desc));
    }

    protected int getOccurrenceType(ASTNode node) {
        if (node.getType() == 60) {
            Variable variable = (Variable)node;
            ASTNode parent = variable.getParent();
            int parentType = parent.getType();
            if (parentType == 3) {
                Assignment assignment = (Assignment)parent;
                if (assignment.getLeftHandSide() == node) {
                    return 1;
                }
            } else {
                if (parentType == 44 || parentType == 45 || parentType == 9) {
                    return 1;
                }
                if (parentType == 26 && variable.getLocationInParent() != ForEachStatement.EXPRESSION_PROPERTY) {
                    return 1;
                }
            }
        }
        return 2;
    }

    public String getElementName() {
        return this.globalName;
    }

    public String getID() {
        return ID;
    }

    public void setGlobalScope(boolean isGlobalScope) {
        this.isGlobalScope = isGlobalScope;
    }
}

