/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PerspectiveManager {
    public static boolean fPrompting;

    public static void switchToPerspective(IWorkbenchWindow window, String id) {
        try {
            window.getWorkbench().showPerspective(id, window);
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)window.getShell(), (String)PHPUIMessages.getString("PerspectiveManager_PerspectiveError_Title"), (String)PHPUIMessages.getString("PerspectiveManager_PerspectiveError_Message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldSwitchPerspective(IWorkbenchWindow window, String perspectiveId) {
        MessageDialogWithToggle dialog;
        String perspectiveName = PerspectiveManager.getPerspectiveLabel(perspectiveId);
        String message = NLS.bind((String)PHPUIMessages.getString("PerspectiveManager_Switch_Dialog_Message"), (Object)perspectiveName);
        String preferenceKey = String.valueOf(perspectiveId) + ".switch_to_perspective";
        if (PerspectiveManager.isCurrentPerspective(window, perspectiveId)) {
            return false;
        }
        if (perspectiveName == null) {
            return false;
        }
        String switchPerspective = PHPUiPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("always".equals(switchPerspective)) {
            return true;
        }
        if ("never".equals(switchPerspective)) {
            return false;
        }
        Shell shell = window.getShell();
        if (shell == null || fPrompting) {
            return false;
        }
        fPrompting = true;
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        boolean answer = (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)PHPUIMessages.getString("PerspectiveManager_Switch_Dialog_Title"), (String)message, null, (boolean)false, (IPreferenceStore)PHPUiPlugin.getDefault().getPreferenceStore(), (String)preferenceKey)).getReturnCode() == 2;
        Class<PerspectiveManager> clazz = PerspectiveManager.class;
        synchronized (PerspectiveManager.class) {
            fPrompting = false;
            PerspectiveManager.class.notifyAll();
            // ** MonitorExit[var9_9] (shouldn't be in output)
            if (PerspectiveManager.isCurrentPerspective(window, perspectiveId)) {
                answer = false;
            }
            return answer;
        }
    }

    public static boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    public static String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }
}

