/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

class OpenLocationAction
extends SelectionDispatchAction {
    private CallHierarchyViewPart fPart;

    public OpenLocationAction(CallHierarchyViewPart part, IWorkbenchSite site) {
        super(site);
        this.fPart = part;
        this.setText(CallHierarchyMessages.OpenLocationAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenLocationAction_tooltip);
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof MethodWrapper || element instanceof CallLocation) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            boolean noError = CallHierarchyUI.openInEditor(iter.next(), this.getShell(), this.getDialogTitle());
            if (noError) continue;
            return;
        }
    }

    private String getDialogTitle() {
        return CallHierarchyMessages.OpenLocationAction_error_title;
    }
}

