/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fResourceToItem = new HashMap();
    private Stack fReuseLists = new Stack();
    private IContentViewerAccessor fContentViewerAccess;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ResourceToItemsMapper(IContentViewerAccessor viewer) {
        this.fContentViewerAccess = viewer;
    }

    public void resourceChanged(IResource changedResource) {
        Object obj = this.fResourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                this.updateItem((Item)obj);
            } else {
                List list = (List)obj;
                int k = 0;
                while (k < list.size()) {
                    this.updateItem((Item)list.get(k));
                    ++k;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            this.fContentViewerAccess.doUpdateItem((Widget)item);
        }
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                this.fResourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List list = this.getNewList();
                    list.add(existingMapping);
                    list.add(item);
                    this.fResourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fResourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(IModelElement elem) {
        ISourceModule cu;
        IResource res = elem.getResource();
        if (res == null && (cu = (ISourceModule)elem.getAncestor(5)) != null) {
            res = cu.getResource();
        }
        return res;
    }

    private static IResource getCorrespondingResource(Object element) {
        if (element instanceof IModelElement) {
            return ResourceToItemsMapper.getCorrespondingResource((IModelElement)element);
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            IModelElement elem;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (IModelElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                return ResourceToItemsMapper.getCorrespondingResource(elem);
            }
            IAdaptable iAdaptable2 = (IAdaptable)element;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource res = (IResource)iAdaptable2.getAdapter((Class)clazz2);
            return res;
        }
        return null;
    }

    public static interface IContentViewerAccessor {
        public void doUpdateItem(Widget var1);
    }
}

