/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.CharClasses;
import JFlex.DFA;
import JFlex.IntPair;
import JFlex.LexScan;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import JFlex.RegExps;
import JFlex.StateSet;
import JFlex.StateSetEnumerator;
import java.util.Hashtable;
import java.util.Vector;

public final class NFA {
    private static final int STATES = 128;
    StateSet[][] table;
    StateSet[] epsilon;
    boolean[] isFinal;
    boolean[] isPushback;
    boolean[] hadPushback;
    int startState;
    int finalState;
    Action[] action;
    int numStates;
    int numInput;
    int numLexStates;
    Macros macros;
    CharClasses classes;
    LexScan scanner;
    RegExps regExps;
    private static StateSetEnumerator states = new StateSetEnumerator();
    private static StateSet tempStateSet = new StateSet();

    public NFA(int n) {
        this.numInput = n;
        this.numStates = 0;
        this.startState = 0;
        this.epsilon = new StateSet[128];
        this.action = new Action[128];
        this.isFinal = new boolean[128];
        this.isPushback = new boolean[128];
        this.hadPushback = new boolean[128];
        this.table = new StateSet[128][n];
    }

    public NFA(int n, LexScan lexScan, RegExps regExps, Macros macros, CharClasses charClasses) {
        this(n);
        this.scanner = lexScan;
        this.regExps = regExps;
        this.macros = macros;
        this.classes = charClasses;
        this.action = new Action[128];
        this.isFinal = new boolean[128];
        this.numLexStates = lexScan.states.number();
        this.ensureCapacity(2 * this.numLexStates);
        this.numStates = 2 * this.numLexStates;
    }

    public void addStandaloneRule() {
        int n = this.numStates;
        int n2 = this.numStates + 1;
        int n3 = 0;
        while (n3 < this.classes.getNumClasses()) {
            this.addTransition(n, n3, n2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.numLexStates * 2) {
            this.addEpsilonTransition(n4, n);
            ++n4;
        }
        this.action[n2] = new Action("System.out.print(yytext());", Integer.MAX_VALUE);
        this.isFinal[n2] = true;
    }

    /*
     * Unable to fully structure code
     */
    public void addRegExp(int var1_1) {
        block5: {
            var2_2 = this.insertNFA(this.regExps.getRegExp(var1_1));
            var3_3 = this.regExps.getStates(var1_1).elements();
            if (var3_3.hasMoreElements()) ** GOTO lbl16
            var4_4 = 0;
            while (var4_4 < this.numLexStates) {
                if (!this.regExps.isBOL(var1_1)) {
                    this.addEpsilonTransition(2 * var4_4, var2_2.start);
                }
                this.addEpsilonTransition(2 * var4_4 + 1, var2_2.start);
                ++var4_4;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var4_4 = (Integer)var3_3.nextElement();
                if (!this.regExps.isBOL(var1_1)) {
                    this.addEpsilonTransition(2 * var4_4, var2_2.start);
                }
                this.addEpsilonTransition(2 * var4_4 + 1, var2_2.start);
lbl16:
                // 2 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        if (this.regExps.getLookAhead(var1_1) != null) {
            var4_5 = this.insertNFA(this.regExps.getLookAhead(var1_1));
            this.addEpsilonTransition(var2_2.end, var4_5.start);
            this.isPushback[var2_2.end] = true;
            this.hadPushback[var4_5.end] = true;
            this.action[var4_5.end] = this.regExps.getAction(var1_1);
            this.isFinal[var4_5.end] = true;
            return;
        }
        this.action[var2_2.end] = this.regExps.getAction(var1_1);
        this.isFinal[var2_2.end] = true;
    }

    private void ensureCapacity(int n) {
        int n2 = this.epsilon.length;
        if (n < n2) {
            return;
        }
        int n3 = Math.max(n2 * 2, n);
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        boolean[] blArray3 = new boolean[n3];
        Action[] actionArray = new Action[n3];
        StateSet[][] stateSetArray = new StateSet[n3][this.numInput];
        StateSet[] stateSetArray2 = new StateSet[n3];
        System.arraycopy(this.isFinal, 0, blArray, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, blArray2, 0, this.numStates);
        System.arraycopy(this.hadPushback, 0, blArray3, 0, this.numStates);
        System.arraycopy(this.action, 0, actionArray, 0, this.numStates);
        System.arraycopy(this.epsilon, 0, stateSetArray2, 0, this.numStates);
        System.arraycopy(this.table, 0, stateSetArray, 0, this.numStates);
        this.isFinal = blArray;
        this.isPushback = blArray2;
        this.hadPushback = blArray3;
        this.action = actionArray;
        this.epsilon = stateSetArray2;
        this.table = stateSetArray;
    }

    public void addTransition(int n, int n2, int n3) {
        int n4 = Math.max(n, n3) + 1;
        this.ensureCapacity(n4);
        if (n4 > this.numStates) {
            this.numStates = n4;
        }
        if (this.table[n][n2] != null) {
            this.table[n][n2].addState(n3);
            return;
        }
        this.table[n][n2] = new StateSet(n3);
    }

    public void addEpsilonTransition(int n, int n2) {
        int n3 = Math.max(n, n2) + 1;
        this.ensureCapacity(n3);
        if (n3 > this.numStates) {
            this.numStates = n3;
        }
        if (this.epsilon[n] != null) {
            this.epsilon[n].addState(n2);
            return;
        }
        this.epsilon[n] = new StateSet(n2);
    }

    private boolean containsFinal(StateSet stateSet) {
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            if (!this.isFinal[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private boolean containsPushback(StateSet stateSet) {
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            if (!this.isPushback[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private boolean containsLookAheadEnd(StateSet stateSet) {
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            if (!this.hadPushback[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private Action getAction(StateSet stateSet) {
        states.reset(stateSet);
        Action action = null;
        while (states.hasMoreElements()) {
            Action action2 = this.action[states.nextElement()];
            if (action2 == null) continue;
            action = action == null ? action2 : action.getHigherPriority(action2);
        }
        return action;
    }

    private StateSet closure(int n) {
        StateSet stateSet = tempStateSet;
        StateSet stateSet2 = new StateSet(n);
        stateSet.clear();
        stateSet.addState(n);
        while (stateSet.containsElements()) {
            int n2 = stateSet.getAndRemoveElement();
            stateSet.add(stateSet2.complement(this.epsilon[n2]));
            stateSet2.add(this.epsilon[n2]);
        }
        return stateSet2;
    }

    private void epsilonFill() {
        int n = 0;
        while (n < this.numStates) {
            this.epsilon[n] = this.closure(n);
            ++n;
        }
    }

    private StateSet DFAEdge(StateSet stateSet, char c) {
        tempStateSet.clear();
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            tempStateSet.add(this.table[states.nextElement()][c]);
        }
        StateSet stateSet2 = new StateSet(tempStateSet);
        states.reset(tempStateSet);
        while (states.hasMoreElements()) {
            stateSet2.add(this.epsilon[states.nextElement()]);
        }
        return stateSet2;
    }

    public DFA getDFA() {
        StateSet stateSet;
        Hashtable<StateSet, Integer> hashtable = new Hashtable<StateSet, Integer>(this.numStates);
        Vector<StateSet> vector = new Vector<StateSet>(this.numStates);
        DFA dFA = new DFA(2 * this.numLexStates, this.numInput);
        int n = 0;
        int n2 = 0;
        Out.println("Converting NFA to DFA : ");
        this.epsilonFill();
        int n3 = 0;
        while (n3 < 2 * this.numLexStates) {
            stateSet = this.epsilon[n3];
            hashtable.put(stateSet, new Integer(n));
            vector.addElement(stateSet);
            dFA.setLexState(n3, n);
            dFA.setFinal(n, this.containsFinal(stateSet));
            dFA.setPushback(n, this.containsPushback(stateSet));
            dFA.setLookEnd(n, this.containsLookAheadEnd(stateSet));
            dFA.setAction(n, this.getAction(stateSet));
            ++n;
            ++n3;
        }
        --n;
        n2 = 0;
        while (n2 <= n) {
            StateSet stateSet2 = (StateSet)vector.elementAt(n2);
            char c = '\u0000';
            while (c < this.numInput) {
                stateSet = this.DFAEdge(stateSet2, c);
                if (stateSet.containsElements()) {
                    Integer n4 = (Integer)hashtable.get(stateSet);
                    if (n4 != null) {
                        dFA.addTransition(n2, c, n4);
                    } else {
                        if (Out.VERBOSE) {
                            Out.print(".");
                        }
                        hashtable.put(stateSet, new Integer(++n));
                        vector.addElement(stateSet);
                        dFA.addTransition(n2, c, n);
                        dFA.setFinal(n, this.containsFinal(stateSet));
                        dFA.setPushback(n, this.containsPushback(stateSet));
                        dFA.setLookEnd(n, this.containsLookAheadEnd(stateSet));
                        dFA.setAction(n, this.getAction(stateSet));
                    }
                }
                c = (char)(c + '\u0001');
            }
            ++n2;
        }
        if (Out.VERBOSE) {
            Out.println("");
        }
        return dFA;
    }

    public void dumpTable() {
        Out.dump(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numStates) {
            stringBuffer.append("State");
            if (this.isFinal[n]) {
                stringBuffer.append("[FINAL]");
            }
            if (this.isPushback[n]) {
                stringBuffer.append(" [PUSHBACK]");
            }
            if (this.hadPushback[n]) {
                stringBuffer.append(" [IS_LOOKAHEAD]");
            }
            stringBuffer.append(" " + n + Out.NL);
            int n2 = 0;
            while (n2 < this.numInput) {
                if (this.table[n][n2] != null && this.table[n][n2].containsElements()) {
                    stringBuffer.append("  with " + n2 + " in " + this.table[n][n2] + Out.NL);
                }
                n2 = (char)(n2 + 1);
            }
            if (this.epsilon[n] != null && this.epsilon[n].containsElements()) {
                stringBuffer.append("  with epsilon in " + this.epsilon[n] + Out.NL);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntPair insertLetterNFA(char c) {
        int n = this.numStates;
        int n2 = this.numStates + 1;
        this.addTransition(n, this.classes.getClassCode(c), n2);
        return new IntPair(n, n2);
    }

    public IntPair insertStringNFA(String string) {
        int n = this.numStates;
        int n2 = 0;
        while (n2 < string.length()) {
            this.addTransition(n2 + n, this.classes.getClassCode(string.charAt(n2)), n2 + n + 1);
            ++n2;
        }
        return new IntPair(n, n2 + n);
    }

    public IntPair insertClassNFA(Vector vector) {
        int[] nArray = this.classes.getClassCodes(vector);
        int n = this.numStates;
        int n2 = this.numStates + 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addTransition(n, nArray[n3], n2);
            ++n3;
        }
        return new IntPair(n, n2);
    }

    public IntPair insertNotClassNFA(Vector vector) {
        int[] nArray = this.classes.getNotClassCodes(vector);
        int n = this.numStates;
        int n2 = this.numStates + 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addTransition(n, nArray[n3], n2);
            ++n3;
        }
        return new IntPair(n, n2);
    }

    public IntPair insertNFA(RegExp regExp) {
        switch (regExp.type) {
            case 6: {
                RegExp2 regExp2 = (RegExp2)regExp;
                IntPair intPair = this.insertNFA(regExp2.r1);
                IntPair intPair2 = this.insertNFA(regExp2.r2);
                int n = intPair2.end + 1;
                int n2 = intPair2.end + 2;
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(n, intPair2.start);
                this.addEpsilonTransition(intPair.end, n2);
                this.addEpsilonTransition(intPair2.end, n2);
                return new IntPair(n, n2);
            }
            case 42: {
                RegExp2 regExp2 = (RegExp2)regExp;
                IntPair intPair = this.insertNFA(regExp2.r1);
                IntPair intPair3 = this.insertNFA(regExp2.r2);
                this.addEpsilonTransition(intPair.end, intPair3.start);
                return new IntPair(intPair.start, intPair3.end);
            }
            case 4: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int n = intPair.end + 1;
                int n3 = intPair.end + 2;
                this.addEpsilonTransition(intPair.end, n3);
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(n, n3);
                this.addEpsilonTransition(intPair.end, intPair.start);
                return new IntPair(n, n3);
            }
            case 5: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int n = intPair.end + 1;
                int n4 = intPair.end + 2;
                this.addEpsilonTransition(intPair.end, n4);
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(intPair.end, intPair.start);
                return new IntPair(n, n4);
            }
            case 7: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(intPair.start, intPair.end);
                return new IntPair(intPair.start, intPair.end);
            }
            case 40: {
                return this.insertClassNFA((Vector)((RegExp1)regExp).content);
            }
            case 41: {
                return this.insertNotClassNFA((Vector)((RegExp1)regExp).content);
            }
            case 33: {
                return this.insertLetterNFA(((Character)((RegExp1)regExp).content).charValue());
            }
            case 35: {
                return this.insertStringNFA((String)((RegExp1)regExp).content);
            }
            case 38: {
                return this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content));
            }
        }
        return null;
    }
}

