/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class XSDElementDeclarationAdvancedSection
extends AbstractSection {
    private static final String EMPTY = "";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected CCombo blockCombo;
    protected CCombo finalCombo;
    protected CCombo abstractCombo;
    protected CCombo substGroupCombo;
    protected CCombo nillableCombo;
    private boolean isTraversing = false;
    private String[] blockValues = new String[]{"", "#all", "extension", "restriction", "substitution"};
    private String[] finalValues = new String[]{"", "#all", "extension", "restriction"};
    private String[] booleanValues = new String[]{"", "true", "false"};
    static /* synthetic */ Class class$0;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel abstractLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_ABSTRACT) + ":");
        abstractLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.abstractCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.abstractCombo.setLayoutData((Object)data);
        this.abstractCombo.setEditable(false);
        this.abstractCombo.setItems(this.booleanValues);
        this.abstractCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel blockLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_BLOCK) + ":");
        blockLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.blockCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.blockCombo.setLayoutData((Object)data);
        this.blockCombo.setEditable(false);
        this.blockCombo.setItems(this.blockValues);
        this.blockCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel finalLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_FINAL) + ":");
        finalLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.finalCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.finalCombo.setLayoutData((Object)data);
        this.finalCombo.setEditable(false);
        this.finalCombo.setItems(this.finalValues);
        this.finalCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel subGroupLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_SUBSTITUTION_GROUP) + ":");
        subGroupLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.substGroupCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.substGroupCombo.setLayoutData((Object)data);
        this.substGroupCombo.setEditable(true);
        this.substGroupCombo.addSelectionListener((SelectionListener)this);
        this.substGroupCombo.addListener(31, (Listener)this);
        this.applyAllListeners((Control)this.substGroupCombo);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nillableLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_NILLABLE) + ":");
        nillableLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nillableCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.nillableCombo.setLayoutData((Object)data);
        this.nillableCombo.setEditable(false);
        this.nillableCombo.setItems(this.booleanValues);
        this.nillableCombo.addSelectionListener((SelectionListener)this);
    }

    public void doHandleEvent(Event e) {
        if (e.widget == this.substGroupCombo) {
            if (e.type == 31 && (e.detail == 64 || e.detail == 32)) {
                this.isTraversing = true;
                return;
            }
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.substGroupCombo.getText();
            String oldValue = eleDec.getElement().getAttribute("substitutionGroup");
            if (oldValue == null) {
                oldValue = EMPTY;
            }
            if (value.equals(oldValue)) {
                return;
            }
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "substitutionGroup", value, Messages._UI_LABEL_SUBSTITUTION_GROUP);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        }
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.substGroupCombo) {
            String selection = this.substGroupCombo.getText();
            if (this.shouldPerformComboSelection(14, selection)) {
                this.handleWidgetSelection(e);
            }
        } else {
            this.handleWidgetSelection(e);
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.substGroupCombo) {
            String selection = this.substGroupCombo.getText();
            if (this.shouldPerformComboSelection(13, selection)) {
                this.handleWidgetSelection(e);
            }
        } else {
            this.handleWidgetSelection(e);
        }
    }

    private void handleWidgetSelection(SelectionEvent e) {
        if (e.widget == this.blockCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.blockCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "block", value, Messages._UI_LABEL_BLOCK);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.finalCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.finalCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "final", value, Messages._UI_LABEL_FINAL);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.abstractCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.abstractCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "abstract", value, Messages._UI_LABEL_ABSTRACT);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.substGroupCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.substGroupCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                } else {
                    this.substGroupCombo.setText(EMPTY);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else if (e.widget == this.nillableCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.nillableCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "nillable", value, Messages._UI_LABEL_NILLABLE);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        }
    }

    public void refresh() {
        super.refresh();
        this.fillSubstitutionGroupCombo();
        this.setListenerEnabled(false);
        try {
            if (this.input instanceof XSDElementDeclaration) {
                XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
                this.composite.setEnabled(!this.isReadOnly);
                if (eleDec.getContainer() instanceof XSDSchema) {
                    this.abstractCombo.setEnabled(true);
                    this.finalCombo.setEnabled(true);
                    this.substGroupCombo.setEnabled(true);
                    this.nillableCombo.setEnabled(true);
                } else {
                    this.abstractCombo.setEnabled(false);
                    this.finalCombo.setEnabled(false);
                    this.substGroupCombo.setEnabled(false);
                    this.nillableCombo.setEnabled(!eleDec.isElementDeclarationReference());
                }
                Element element = eleDec.getElement();
                String blockAttValue = element.getAttribute("block");
                if (blockAttValue != null) {
                    this.blockCombo.setText(blockAttValue);
                } else {
                    this.blockCombo.setText(EMPTY);
                }
                if (element.hasAttribute("nillable")) {
                    String attrValue = element.getAttribute("nillable");
                    this.nillableCombo.setText(attrValue);
                } else {
                    this.nillableCombo.setText(EMPTY);
                }
                String finalAttValue = element.getAttribute("final");
                if (finalAttValue != null) {
                    this.finalCombo.setText(finalAttValue);
                } else {
                    this.finalCombo.setText(EMPTY);
                }
                if (element.hasAttribute("abstract")) {
                    this.abstractCombo.setText(element.getAttribute("abstract"));
                } else {
                    this.abstractCombo.setText(EMPTY);
                }
                if (element.hasAttribute("substitutionGroup")) {
                    this.substGroupCombo.setText(element.getAttribute("substitutionGroup"));
                } else {
                    this.substGroupCombo.setText(EMPTY);
                }
            }
        }
        catch (Exception exception) {}
        this.setListenerEnabled(true);
    }

    private void fillSubstitutionGroupCombo() {
        ComponentReferenceEditManager manager;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz)) != null) {
            ComponentSpecification ret;
            ComponentSpecification[] items = manager.getQuickPicks();
            this.substGroupCombo.removeAll();
            this.substGroupCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
            this.substGroupCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
            int i = 0;
            while (i < items.length) {
                this.substGroupCombo.add(items[i].getName());
                ++i;
            }
            XSDElementDeclaration namedComponent = ((XSDElementDeclaration)this.input).getSubstitutionGroupAffiliation();
            if (namedComponent != null && (ret = this.getComponentSpecFromQuickPickForValue(namedComponent.getName(), manager)) == null) {
                this.substGroupCombo.add(namedComponent.getQName((XSDConcreteComponent)this.xsdSchema));
            }
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value != null && value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean shouldPerformComboSelection(int eventType, Object selectedItem) {
        boolean wasTraversing = this.isTraversing;
        if (this.isTraversing) {
            this.isTraversing = false;
        }
        if (eventType == 14) {
            return selectedItem instanceof String && (org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE.equals(selectedItem) || org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW.equals(selectedItem));
        }
        return !wasTraversing || !(selectedItem instanceof String) || !org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE.equals(selectedItem) && !org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW.equals(selectedItem);
    }

    public void dispose() {
        if (this.substGroupCombo != null && !this.substGroupCombo.isDisposed()) {
            this.substGroupCombo.removeListener(31, (Listener)this);
        }
        super.dispose();
    }
}

