/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.eclipse.dltk.internal.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointPathMapper;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;

public class RemoteScriptDebugTarget
extends ScriptDebugTarget {
    private static final String LAUNCH_CONFIGURATION_ATTR_REMOTE_WORKING_DIR = "remoteWorkingDir";
    private static final String LAUNCH_CONFIGURATION_ATTR_STRIP_SRC_FOLDERS = "stripSourceFolders";

    public RemoteScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) {
        super(modelId, dbgpService, sessionId, launch, process);
    }

    public RemoteScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process, IDebugOptions options) {
        super(modelId, dbgpService, sessionId, launch, process, options);
    }

    protected IScriptBreakpointPathMapper createPathMapper() {
        String remoteWorkingDir = null;
        boolean stripSrcFolders = false;
        try {
            remoteWorkingDir = this.getLaunch().getLaunchConfiguration().getAttribute(LAUNCH_CONFIGURATION_ATTR_REMOTE_WORKING_DIR, "");
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        try {
            stripSrcFolders = this.getLaunch().getLaunchConfiguration().getAttribute(LAUNCH_CONFIGURATION_ATTR_STRIP_SRC_FOLDERS, false);
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return new ScriptBreakpointPathMapper(this.getScriptProject(), remoteWorkingDir, stripSrcFolders);
    }
}

