/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.presentation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.JETAddNatureOperation;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.presentation.CodeGenUIPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ConvertToJETProjectWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected List<IProject> projectsToConvert = new ArrayList<IProject>();
    protected ConversionPage conversionPage;

    public ConvertToJETProjectWizard() {
        this.setWindowTitle(CodeGenUIPlugin.getPlugin().getString("_UI_JETConvertProject_label"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        for (Object object : selection.toList()) {
            IProject project;
            if (!(object instanceof IProject) || !(project = (IProject)object).isOpen() || JETNature.getRuntime((IProject)project) != null) continue;
            this.projectsToConvert.add(project);
        }
    }

    public void addPages() {
        super.addPages();
        this.conversionPage = new ConversionPage();
        this.addPage((IWizardPage)this.conversionPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    JETAddNatureOperation addNature = new JETAddNatureOperation(ConvertToJETProjectWizard.this.projectsToConvert);
                    addNature.run(monitor);
                }
                catch (CoreException e) {
                    CodeGenUIPlugin.write((Exception)((Object)e));
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException exception) {
            CodeGenUIPlugin.write(exception);
        }
        catch (InvocationTargetException exception) {
            CodeGenUIPlugin.write(exception);
        }
        return true;
    }

    public class ConversionPage
    extends WizardPage {
        public ConversionPage() {
            super("JETConversionPage");
            this.setTitle(CodeGenUIPlugin.getPlugin().getString("_UI_JETConvertProject_label"));
            ConvertToJETProjectWizard.this.setDefaultPageImageDescriptor(CodeGenUIPlugin.getPlugin().getImage("full/wizban/ConvertToJETProjectWizard"));
            this.setDescription(CodeGenUIPlugin.getPlugin().getString("_UI_JETConvertProject_message"));
        }

        public boolean isPageComplete() {
            return !ConvertToJETProjectWizard.this.projectsToConvert.isEmpty();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 10;
            layout.marginLeft = 10;
            layout.marginRight = 10;
            layout.spacing = 10;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label projectsLabel = new Label(composite, 16384);
            projectsLabel.setText(CodeGenUIPlugin.getPlugin().getString("_UI_Projects_label"));
            data = new FormData();
            data.left = new FormAttachment(0);
            projectsLabel.setLayoutData((Object)data);
            Table projectsTable = new Table(composite, 2080);
            FormData data2 = new FormData(-1, 250);
            data2.top = new FormAttachment((Control)projectsLabel, 5);
            data2.bottom = new FormAttachment(100);
            data2.left = new FormAttachment(0);
            data2.right = new FormAttachment(100);
            data2.height = 90;
            projectsTable.setLayoutData((Object)data2);
            Composite selectionComposite = new Composite(composite, 0);
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)projectsLabel, 0, 0x1000000);
            data3.right = new FormAttachment(100);
            selectionComposite.setLayoutData((Object)data3);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            layout2.marginTop = 0;
            layout2.marginBottom = 0;
            layout2.marginRight = 0;
            layout2.marginLeft = 0;
            selectionComposite.setLayout((Layout)layout2);
            Button selectAllButton = new Button(selectionComposite, 8);
            selectAllButton.setText(CodeGenUIPlugin.getPlugin().getString("_UI_SelectAll_label"));
            Button deselectAllButton = new Button(selectionComposite, 8);
            deselectAllButton.setText(CodeGenUIPlugin.getPlugin().getString("_UI_DeselectAll_label"));
            final CheckboxTableViewer projectsCheckboxTableViewer = new CheckboxTableViewer(projectsTable);
            TableLayout layout3 = new TableLayout();
            TableColumn projectColumn = new TableColumn(projectsTable, 0);
            layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            projectColumn.setResizable(true);
            projectsTable.setLayout((Layout)layout3);
            projectsCheckboxTableViewer.setColumnProperties(new String[]{"a"});
            projectsCheckboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            projectsCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object o) {
                    return ((ConversionPage)ConversionPage.this).ConvertToJETProjectWizard.this.workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
                }

                public String getText(Object o) {
                    return ((IProject)o).getName();
                }
            });
            projectsCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ((ConversionPage)ConversionPage.this).ConvertToJETProjectWizard.this.projectsToConvert.clear();
                    List<Object> list = Arrays.asList(projectsCheckboxTableViewer.getCheckedElements());
                    ((ConversionPage)ConversionPage.this).ConvertToJETProjectWizard.this.projectsToConvert.addAll(list);
                    ConversionPage.this.setPageComplete(ConversionPage.this.isPageComplete());
                }
            });
            final ArrayList projects = new ArrayList(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
            Iterator i = projects.iterator();
            while (i.hasNext()) {
                IProject project = (IProject)i.next();
                boolean isJavaProject = false;
                try {
                    isJavaProject = project.getNature("org.eclipse.jdt.core.javanature") != null;
                }
                catch (CoreException coreException) {}
                if (project.isOpen() && JETNature.getRuntime((IProject)project) == null && isJavaProject) continue;
                i.remove();
            }
            projectsCheckboxTableViewer.setInput((Object)projects.toArray());
            projectsCheckboxTableViewer.setCheckedElements(ConvertToJETProjectWizard.this.projectsToConvert.toArray());
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ((ConversionPage)ConversionPage.this).ConvertToJETProjectWizard.this.projectsToConvert.addAll(projects);
                    projectsCheckboxTableViewer.setCheckedElements(projects.toArray());
                    ConversionPage.this.setPageComplete(ConversionPage.this.isPageComplete());
                }
            });
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    projectsCheckboxTableViewer.setCheckedElements(new Object[0]);
                    ((ConversionPage)ConversionPage.this).ConvertToJETProjectWizard.this.projectsToConvert.clear();
                    ConversionPage.this.setPageComplete(ConversionPage.this.isPageComplete());
                }
            });
            this.setControl((Control)composite);
            this.setPageComplete(this.isPageComplete());
        }
    }
}

