/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.osgi.framework.BundleContext;

public class Uninstall
extends InstallableUnitPhase {
    private static final String PHASE_ID = "uninstall";

    public Uninstall(int weight) {
        super(PHASE_ID, weight);
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.first() != null;
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand currentOperand) {
        BeforeUninstallEventAction beforeAction = new BeforeUninstallEventAction();
        AfterUninstallEventAction afterAction = new AfterUninstallEventAction();
        IInstallableUnit unit = currentOperand.first();
        if (unit.isFragment()) {
            return new ProvisioningAction[]{beforeAction, afterAction};
        }
        ProvisioningAction[] parsedActions = this.getActions(unit, this.phaseId);
        if (parsedActions == null) {
            return new ProvisioningAction[]{beforeAction, afterAction};
        }
        ProvisioningAction[] actions = new ProvisioningAction[parsedActions.length + 2];
        actions[0] = beforeAction;
        System.arraycopy(parsedActions, 0, actions, 1, parsedActions.length);
        actions[actions.length - 1] = afterAction;
        return actions;
    }

    protected String getProblemMessage() {
        return Messages.Phase_Uninstall_Error;
    }

    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        IInstallableUnit iu = operand.first();
        parameters.put("iu", iu);
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts != null && artifacts.length > 0) {
            parameters.put("artifact", artifacts[0]);
        }
        return Status.OK_STATUS;
    }

    static final class AfterUninstallEventAction
    extends ProvisioningAction {
        AfterUninstallEventAction() {
        }

        public IStatus execute(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            Touchpoint touchpoint = (Touchpoint)parameters.get("touchpoint");
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            profile.removeInstallableUnit(iu);
            ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, false, profile, operand, 0, touchpoint));
            return null;
        }

        public IStatus undo(Map parameters) {
            IProfile profile = (IProfile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            Touchpoint touchpoint = (Touchpoint)parameters.get("touchpoint");
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
            ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, true, profile, operand, 1, touchpoint));
            return null;
        }
    }

    static final class BeforeUninstallEventAction
    extends ProvisioningAction {
        BeforeUninstallEventAction() {
        }

        public IStatus execute(Map parameters) {
            IProfile profile = (IProfile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            Touchpoint touchpoint = (Touchpoint)parameters.get("touchpoint");
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
            ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, true, profile, operand, 0, touchpoint));
            return null;
        }

        public IStatus undo(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            Touchpoint touchpoint = (Touchpoint)parameters.get("touchpoint");
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            profile.addInstallableUnit(iu);
            ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, false, profile, operand, 1, touchpoint));
            return null;
        }
    }
}

