/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.VersionCollator;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class CVSHistoryTableProvider {
    public static final String CATEGORIES_COLOR = "org.eclipse.team.cvs.ui.fontsandcolors.cvshistorypagecategories";
    private IFileHistory currentFileHistory;
    private IFile workspaceFile;
    TreeViewer viewer;
    Font currentRevisionFont;
    private boolean baseModified;
    private IDialogSettings settings;
    private static final int COL_REVISIONID = 0;
    private static final int COL_TAGS = 1;
    private static final int COL_DATE = 2;
    private static final int COL_AUTHOR = 3;
    private static final int COL_COMMENT = 4;
    private static final String CVS_HISTORY_TABLE_PROVIDER_SECTION;
    private static final String COL_REVISIONID_NAME = "COL_REVISIONID";
    private static final String COL_TAGS_NAME = "COL_TAGS";
    private static final String COL_DATE_NAME = "COL_DATE";
    private static final String COL_AUTHOR_NAME = "COL_AUTHOR";
    private static final String COL_COMMENT_NAME = "COL_COMMENT";
    private static final String COL_NAME = "COLUMN_NAME";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CVS_HISTORY_TABLE_PROVIDER_SECTION = clazz.getName();
    }

    public CVSHistoryTableProvider() {
        IDialogSettings viewsSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = viewsSettings.getSection(CVS_HISTORY_TABLE_PROVIDER_SECTION);
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(CVS_HISTORY_TABLE_PROVIDER_SECTION);
        }
    }

    protected IFileRevision adaptToFileRevision(Object element) {
        IFileRevision entry = null;
        if (element instanceof IFileRevision) {
            entry = (IFileRevision)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entry = (IFileRevision)iAdaptable.getAdapter((Class)clazz);
        } else if (element instanceof AbstractHistoryCategory && ((AbstractHistoryCategory)element).hasRevisions()) {
            entry = ((AbstractHistoryCategory)element).getRevisions()[0];
        }
        return entry;
    }

    public TreeViewer createTree(Composite parent, boolean localIsDisplayed) {
        Tree tree = new Tree(parent, 66306);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        this.viewer = new TreeViewer(tree);
        this.createColumns(this.viewer, layout);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.setLocalRevisionsDisplayed(localIsDisplayed);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CVSHistoryTableProvider.this.currentRevisionFont != null) {
                    CVSHistoryTableProvider.this.currentRevisionFont.dispose();
                }
            }
        });
        return this.viewer;
    }

    private void createColumns(TreeViewer tree, TableLayout layout) {
        SelectionListener headerListener = this.getColumnListener(this.viewer);
        TreeViewerColumn viewerCol = new TreeViewerColumn(tree, 0);
        viewerCol.setLabelProvider((CellLabelProvider)new HistoryLabelProvider(0, this));
        TreeColumn col = viewerCol.getColumn();
        col.setData(COL_NAME, (Object)COL_REVISIONID_NAME);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Revision);
        col.addSelectionListener(headerListener);
        layout.addColumnData(this.loadColumnWeightData(COL_REVISIONID_NAME));
        viewerCol = new TreeViewerColumn(tree, 0);
        viewerCol.setLabelProvider((CellLabelProvider)new HistoryLabelProvider(1, this));
        col = viewerCol.getColumn();
        col.setData(COL_NAME, (Object)COL_TAGS_NAME);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_tags);
        col.addSelectionListener(headerListener);
        layout.addColumnData(this.loadColumnWeightData(COL_TAGS_NAME));
        viewerCol = new TreeViewerColumn(tree, 0);
        viewerCol.setLabelProvider((CellLabelProvider)new HistoryLabelProvider(2, this));
        col = viewerCol.getColumn();
        col.setData(COL_NAME, (Object)COL_DATE_NAME);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        col.addSelectionListener(headerListener);
        layout.addColumnData(this.loadColumnWeightData(COL_DATE_NAME));
        viewerCol = new TreeViewerColumn(tree, 0);
        viewerCol.setLabelProvider((CellLabelProvider)new HistoryLabelProvider(3, this));
        col = viewerCol.getColumn();
        col.setData(COL_NAME, (Object)COL_AUTHOR_NAME);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Author);
        col.addSelectionListener(headerListener);
        layout.addColumnData(this.loadColumnWeightData(COL_AUTHOR_NAME));
        viewerCol = new TreeViewerColumn(tree, 0);
        viewerCol.setLabelProvider((CellLabelProvider)new HistoryLabelProvider(4, this));
        col = viewerCol.getColumn();
        col.setData(COL_NAME, (Object)COL_COMMENT_NAME);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Comment);
        col.addSelectionListener(headerListener);
        layout.addColumnData(this.loadColumnWeightData(COL_COMMENT_NAME));
    }

    private ColumnLayoutData loadColumnWeightData(String key) {
        try {
            return new ColumnPixelData(this.settings.getInt(key), true);
        }
        catch (NumberFormatException numberFormatException) {
            return new ColumnWeightData(20, true);
        }
    }

    public void saveColumnWeights() {
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            this.settings.put((String)columns[i].getData(COL_NAME), columns[i].getWidth());
            ++i;
        }
    }

    private SelectionListener getColumnListener(final TreeViewer treeViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = treeViewer.getTree().indexOf((TreeColumn)e.widget);
                HistoryComparator oldSorter = (HistoryComparator)treeViewer.getComparator();
                TreeColumn treeColumn = (TreeColumn)e.widget;
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    treeViewer.getTree().setSortColumn(treeColumn);
                    treeViewer.getTree().setSortDirection(oldSorter.isReversed() ? 1024 : 128);
                    treeViewer.refresh();
                } else {
                    treeViewer.getTree().setSortColumn(treeColumn);
                    treeViewer.getTree().setSortDirection(128);
                    treeViewer.setComparator((ViewerComparator)new HistoryComparator(column));
                }
            }
        };
    }

    public void setFile(IFileHistory fileHistory, IFile workspaceFile) {
        this.currentFileHistory = fileHistory;
        this.workspaceFile = workspaceFile;
    }

    public IFileHistory getIFileHistory() {
        return this.currentFileHistory;
    }

    public String getCurrentRevision() {
        try {
            ICVSFile cvsWorkspaceFile;
            byte[] syncBytes;
            if (this.workspaceFile != null && (syncBytes = (cvsWorkspaceFile = CVSWorkspaceRoot.getCVSFileFor((IFile)this.workspaceFile)).getSyncBytes()) != null) {
                String workspaceRevision = ResourceSyncInfo.getRevision((byte[])syncBytes);
                return workspaceRevision;
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public void setLocalRevisionsDisplayed(boolean displayed) {
        HistoryComparator oldSorter;
        int column = 0;
        if (displayed) {
            column = 2;
        }
        if ((oldSorter = (HistoryComparator)this.viewer.getComparator()) != null && column == oldSorter.getColumnNumber()) {
            this.viewer.refresh();
        } else {
            HistoryComparator newSorter = new HistoryComparator(column);
            newSorter.setReversed(true);
            this.viewer.setComparator((ViewerComparator)newSorter);
            this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(column));
            this.viewer.getTree().setSortDirection(newSorter.isReversed() ? 1024 : 128);
        }
    }

    public void setBaseModified(boolean modified) {
        this.baseModified = modified;
    }

    public void setWorkspaceFile(IFile workspaceFile) {
        this.workspaceFile = workspaceFile;
    }

    public static String getCommentAsSingleLine(IFileRevision entry) {
        String comment = entry.getComment();
        if (comment != null) {
            int index = comment.indexOf("\n");
            switch (index) {
                case -1: {
                    return comment;
                }
                case 0: {
                    return CVSUIMessages.HistoryView_______4;
                }
            }
            return NLS.bind((String)CVSUIMessages.CVSCompareRevisionsInput_truncate, (Object[])new String[]{comment.substring(0, index)});
        }
        return "";
    }

    class HistoryComparator
    extends ViewerComparator {
        private boolean reversed = false;
        private int columnNumber;
        private VersionCollator versionCollator = new VersionCollator();
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistoryComparator(int columnNumber) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[5];
            nArray[1] = 2;
            nArray[2] = 3;
            nArray[3] = 4;
            nArray[4] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[5];
            nArray3[0] = 2;
            nArray3[2] = 3;
            nArray3[3] = 4;
            nArray3[4] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[0] = 3;
            nArray4[2] = 2;
            nArray4[3] = 4;
            nArray4[4] = 1;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[5];
            nArray5[0] = 4;
            nArray5[2] = 2;
            nArray5[3] = 3;
            nArray5[4] = 1;
            nArrayArray[4] = nArray5;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            if (o1 instanceof AbstractHistoryCategory || o2 instanceof AbstractHistoryCategory) {
                return 0;
            }
            IFileRevision e1 = CVSHistoryTableProvider.this.adaptToFileRevision(o1);
            IFileRevision e2 = CVSHistoryTableProvider.this.adaptToFileRevision(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(compareViewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, IFileRevision e1, IFileRevision e2) {
            switch (columnNumber) {
                case 0: {
                    if (e1 instanceof LocalFileRevision || e2 instanceof LocalFileRevision) {
                        long date2;
                        long date1 = e1.getTimestamp();
                        if (date1 == (date2 = e2.getTimestamp())) {
                            return 0;
                        }
                        return date1 > date2 ? 1 : -1;
                    }
                    return this.versionCollator.compare(e1.getContentIdentifier(), e2.getContentIdentifier());
                }
                case 1: {
                    ITag[] tags1 = e1.getTags();
                    ITag[] tags2 = e2.getTags();
                    if (tags2.length == 0) {
                        return -1;
                    }
                    if (tags1.length == 0) {
                        return 1;
                    }
                    return this.getComparator().compare(tags1[0].getName(), tags2[0].getName());
                }
                case 2: {
                    long date1 = e1.getTimestamp();
                    long date2 = e2.getTimestamp();
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? 1 : -1;
                }
                case 3: {
                    String author1 = e1.getAuthor();
                    String author2 = e2.getAuthor();
                    if (author2 == null) {
                        return -1;
                    }
                    if (author1 == null) {
                        return 1;
                    }
                    return this.getComparator().compare(author1, author2);
                }
                case 4: {
                    String comment1 = e1.getComment();
                    String comment2 = e2.getComment();
                    if (comment2 == null) {
                        return -1;
                    }
                    if (comment1 == null) {
                        return 1;
                    }
                    return this.getComparator().compare(comment1, comment2);
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }

    class HistoryLabelProvider
    extends ColumnLabelProvider {
        Image dateImage = null;
        ImageDescriptor dateDesc = null;
        Image localRevImage = null;
        ImageDescriptor localRevDesc = null;
        Image remoteRevImage = null;
        ImageDescriptor remoteRevDesc = null;
        ThemeListener themeListener;
        private DateFormat dateFormat;
        private final int column;

        public HistoryLabelProvider(int column, CVSHistoryTableProvider provider) {
            this.column = column;
            this.themeListener = new ThemeListener(provider);
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this.themeListener);
        }

        public void dispose() {
            if (this.dateImage != null) {
                this.dateImage.dispose();
                this.dateImage = null;
            }
            if (this.localRevImage != null) {
                this.localRevImage.dispose();
                this.localRevImage = null;
            }
            if (this.remoteRevImage != null) {
                this.remoteRevImage.dispose();
                this.remoteRevImage = null;
            }
            if (this.themeListener != null) {
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this.themeListener);
            }
        }

        public String getToolTipText(Object element) {
            IFileRevision entry;
            if (this.column == 4 && !this.isSingleLine(element) && (entry = CVSHistoryTableProvider.this.adaptToFileRevision(element)) != null) {
                return entry.getComment();
            }
            return null;
        }

        public boolean useNativeToolTip(Object object) {
            return this.column != 4 || this.isSingleLine(object);
        }

        private boolean isSingleLine(Object object) {
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(object);
            if (entry != null) {
                return entry.getComment() == null || entry.getComment().indexOf(10) == -1;
            }
            return true;
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, this.column);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof DateHistoryCategory && columnIndex == 0) {
                if (this.dateImage == null) {
                    this.dateDesc = CVSUIPlugin.getPlugin().getImageDescriptor("obj16/dates.gif");
                    this.dateImage = this.dateDesc.createImage();
                }
                return this.dateImage;
            }
            if (element instanceof LocalFileRevision && columnIndex == 0) {
                if (this.localRevImage == null) {
                    this.localRevDesc = CVSUIPlugin.getPlugin().getImageDescriptor("obj16/local_entry_tbl.gif");
                    this.localRevImage = this.localRevDesc.createImage();
                }
                return this.localRevImage;
            }
            if (element instanceof CVSFileRevision && columnIndex == 0) {
                if (this.remoteRevImage == null) {
                    this.remoteRevDesc = CVSUIPlugin.getPlugin().getImageDescriptor("obj16/remote_entry_tbl.gif");
                    this.remoteRevImage = this.remoteRevDesc.createImage();
                }
                return this.remoteRevImage;
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, this.column);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AbstractHistoryCategory) {
                if (columnIndex != 0) {
                    return "";
                }
                return ((AbstractHistoryCategory)element).getName();
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = entry.getContentIdentifier();
                    String currentRevision = CVSHistoryTableProvider.this.getCurrentRevision();
                    if (currentRevision != null && currentRevision.equals(revision)) {
                        revision = CVSHistoryTableProvider.this.baseModified ? NLS.bind((String)CVSUIMessages.nameAndRevision, (Object[])new String[]{revision, CVSUIMessages.CVSHistoryTableProvider_base}) : NLS.bind((String)CVSUIMessages.currentRevision, (Object[])new String[]{revision});
                    }
                    return revision;
                }
                case 1: {
                    ITag[] tags = entry.getTags();
                    StringBuffer result = new StringBuffer();
                    int i = 0;
                    while (i < tags.length) {
                        result.append(tags[i].getName());
                        if (i < tags.length - 1) {
                            result.append(", ");
                        }
                        ++i;
                    }
                    return result.toString();
                }
                case 2: {
                    long date = entry.getTimestamp();
                    Date dateFromLong = new Date(date);
                    return this.getDateFormat().format(dateFromLong);
                }
                case 3: {
                    return entry.getAuthor();
                }
                case 4: {
                    return CVSHistoryTableProvider.getCommentAsSingleLine(entry);
                }
            }
            return "";
        }

        private synchronized DateFormat getDateFormat() {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getInstance();
            }
            return this.dateFormat;
        }

        public Color getForeground(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                return current.getColorRegistry().get(CVSHistoryTableProvider.CATEGORIES_COLOR);
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (!entry.exists()) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            LocalFileRevision localRevision;
            if (element instanceof AbstractHistoryCategory) {
                return this.getCurrentRevisionFont();
            }
            IFileRevision entry = CVSHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return null;
            }
            String revision = entry.getContentIdentifier();
            String tempCurrentRevision = CVSHistoryTableProvider.this.getCurrentRevision();
            Font returnFont = null;
            if (tempCurrentRevision != null && tempCurrentRevision.equals(revision)) {
                returnFont = this.getCurrentRevisionFont();
            }
            if (CVSHistoryTableProvider.this.workspaceFile != null && entry instanceof LocalFileRevision && (localRevision = (LocalFileRevision)entry).isCurrentState()) {
                return this.getCurrentRevisionFont();
            }
            return returnFont;
        }

        private Font getCurrentRevisionFont() {
            if (CVSHistoryTableProvider.this.currentRevisionFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                CVSHistoryTableProvider.this.currentRevisionFont = new Font((Device)CVSHistoryTableProvider.this.viewer.getTree().getDisplay(), data);
            }
            return CVSHistoryTableProvider.this.currentRevisionFont;
        }
    }

    private static class ThemeListener
    implements IPropertyChangeListener {
        private final CVSHistoryTableProvider provider;

        ThemeListener(CVSHistoryTableProvider provider) {
            this.provider = provider;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.provider.viewer.refresh();
        }
    }
}

