/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class MarkerCategory
extends MarkerSupportItem {
    int start;
    int end;
    private MarkerEntry[] children;
    private String name;
    private CachedMarkerBuilder cachedMarkerBuilder;
    private int severity = -1;

    MarkerCategory(CachedMarkerBuilder cachedMarkerBuilder, int startIndex, int endIndex, String categoryName) {
        this.cachedMarkerBuilder = cachedMarkerBuilder;
        this.start = startIndex;
        this.end = endIndex;
        this.name = categoryName;
    }

    MarkerSupportItem[] getChildren() {
        if (this.children == null) {
            if (this.cachedMarkerBuilder.isBuilding()) {
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
            }
            MarkerEntry[] allMarkers = this.cachedMarkerBuilder.getMarkerEntries();
            int totalSize = this.getChildrenCount();
            this.children = new MarkerEntry[totalSize];
            System.arraycopy(allMarkers, this.start, this.children, 0, totalSize);
            int i = 0;
            while (i < this.children.length) {
                this.children[i].setCategory(this);
                ++i;
            }
        }
        return this.children;
    }

    int getChildrenCount() {
        return this.end - this.start + 1;
    }

    String getDescription() {
        int size = this.getChildrenCount();
        int limit = MarkerSupportInternalUtilities.getMarkerLimit();
        if (limit > 0 && size > limit) {
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(MarkerSupportInternalUtilities.getMarkerLimit()), String.valueOf(this.getChildrenCount())});
        }
        if (size == 1) {
            return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
        }
        return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(size)});
    }

    int getHighestSeverity() {
        if (this.severity >= 0) {
            return this.severity;
        }
        this.severity = 0;
        MarkerSupportItem[] contents = this.getChildren();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].isConcrete()) {
                int elementSeverity = contents[i].getAttributeValue("severity", -1);
                if (elementSeverity > this.severity) {
                    this.severity = elementSeverity;
                }
                if (this.severity == 2) {
                    return this.severity;
                }
            }
            ++i;
        }
        return this.severity;
    }

    String getName() {
        return this.name;
    }

    MarkerSupportItem getParent() {
        return null;
    }

    boolean isConcrete() {
        return false;
    }
}

