/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class ExternalBreakpointActionHelper {
    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasMarkers(IResource resource, IDocument document, AbstractMarkerAnnotationModel annotationModel, IVerticalRulerInfo rulerInfo) {
        if (resource != null && annotationModel != null) {
            try {
                if (resource.exists()) {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        int i = 0;
                        while (i < allMarkers.length) {
                            if (ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(allMarkers[i]), document, rulerInfo)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                } else {
                    IMarker[] allMarkers = resource.getWorkspace().getRoot().findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                    if (allMarkers != null) {
                        int i = 0;
                        while (i < allMarkers.length) {
                            if (manager.getBreakpoint(allMarkers[i]) != null && ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(allMarkers[i]), document, rulerInfo)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static IMarker[] getMarkers(IResource resource, IDocument document, AbstractMarkerAnnotationModel annotationModel, IVerticalRulerInfo rulerInfo) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (resource != null && annotationModel != null) {
            try {
                if (resource.exists()) {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        int i = 0;
                        while (i < allMarkers.length) {
                            if (ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(allMarkers[i]), document, rulerInfo)) {
                                markers.add(allMarkers[i]);
                            }
                            ++i;
                        }
                    }
                } else {
                    IMarker[] allMarkers = resource.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                        int i = 0;
                        while (i < allMarkers.length) {
                            if (manager.getBreakpoint(allMarkers[i]) != null && ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(allMarkers[i]), document, rulerInfo)) {
                                markers.add(allMarkers[i]);
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return markers.toArray(new IMarker[0]);
    }

    private static boolean includesRulerLine(Position position, IDocument document, IVerticalRulerInfo rulerInfo) {
        if (position != null && rulerInfo != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = rulerInfo.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

