/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.Logger;

public class PHPHyperlinkDetector
implements IHyperlinkDetectorForPHP {
    private IEditorPart fEditor;

    public PHPHyperlinkDetector(IEditorPart editor) {
        this.fEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion wordRegion;
        ISourceModule input;
        block9: {
            if (region == null) {
                return null;
            }
            input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false);
            if (input == null) {
                return null;
            }
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            try {
                while (offset > 0 && !Character.isJavaIdentifierPart(document.getChar(offset))) {
                    --offset;
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
            try {
                wordRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
                if (wordRegion != null) break block9;
                return null;
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        IModelElement[] elements = null;
        elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
        if (elements != null && elements.length > 0) {
            ModelElementHyperlink link = elements.length == 1 ? new ModelElementHyperlink(wordRegion, (Object)elements[0], new OpenAction(this.fEditor)) : new ModelElementHyperlink(wordRegion, (Object)new ModelElementArray(elements), new OpenAction(this.fEditor));
            return new IHyperlink[]{link};
        }
        return null;
    }
}

