/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationPropertiesNew;

public class PHPModelCreationOperation
extends AbstractDataModelOperation
implements IProjectCreationPropertiesNew {
    private List wizardPageFactories = new ArrayList();

    public PHPModelCreationOperation(IDataModel dataModel, List wizardPageFactories) {
        super(dataModel);
        this.wizardPageFactories = wizardPageFactories;
    }

    public PHPModelCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block9: {
            try {
                try {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
                    final IProjectDescription desc = (IProjectDescription)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_DESCRIPTION");
                    final IProject project = (IProject)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT");
                    if (!project.exists()) {
                        project.create(desc, (IProgressMonitor)subMonitor);
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    subMonitor = new SubProgressMonitor(monitor, -1);
                    project.open((IProgressMonitor)subMonitor);
                    if (this.model.isPropertySet("phpVersion")) {
                        String version = this.model.getStringProperty("phpVersion");
                        PhpVersionProjectPropertyHandler.setVersion((String)version, (IProject)project);
                        boolean useASPTags = this.model.getBooleanProperty("use_asp_tags_as_php");
                        UseAspTagsHandler.setUseAspTagsAsPhp((boolean)useASPTags, (IProject)project);
                    }
                    WorkspaceJob job = new WorkspaceJob("Saving project options"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            String[] natureIds;
                            for (WizardPageFactory pageFactory : PHPModelCreationOperation.this.wizardPageFactories) {
                                pageFactory.execute();
                            }
                            if (PHPModelCreationOperation.this.model.getBooleanProperty("org.eclipse.php.core.addJsNature")) {
                                String[] oldNatureIds = (String[])PHPModelCreationOperation.this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_NATURES");
                                String[] newNatureIds = new String[oldNatureIds.length + 1];
                                newNatureIds[oldNatureIds.length] = "org.eclipse.wst.jsdt.core.jsNature";
                                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                                PHPModelCreationOperation.this.model.setProperty("IProjectCreationPropertiesNew.PROJECT_NATURES", (Object)newNatureIds);
                            }
                            if ((natureIds = (String[])PHPModelCreationOperation.this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_NATURES")) != null) {
                                desc.setNatureIds(natureIds);
                                project.setDescription(desc, monitor);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
                    job.schedule();
                    this.createDefaultProjectStructure(monitor, project);
                }
                catch (CoreException e) {
                    Logger.logException((Throwable)e);
                    monitor.done();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return OK_STATUS;
    }

    protected void createDefaultProjectStructure(IProgressMonitor monitor, IProject project) {
        try {
            this.createFolder(project, monitor, "src");
            this.createFolder(project, monitor, "resources");
        }
        catch (CoreException e) {
            Logger.logException((String)"Failed creating project initial structure", (Throwable)e);
        }
    }

    private IFolder createFolder(IProject project, IProgressMonitor monitor, String folderName) throws CoreException {
        IFolder folder = project.getFolder(folderName);
        if (!folder.isAccessible()) {
            folder.create(true, true, monitor);
        }
        return folder;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }
}

