/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.RemoteScriptDebugTarget;
import org.eclipse.dltk.launching.DebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;

public abstract class RemoteDebuggingEngineRunner
extends DebuggingEngineRunner {
    public RemoteDebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    protected IScriptDebugTarget createDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        return new RemoteScriptDebugTarget(this.getDebugModelId(), dbgpService, this.getSessionId(launch.getLaunchConfiguration()), launch, null);
    }

    protected String getSessionId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("dbgp_session_id", "");
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        return this.addEngineConfig(config, delegate, null);
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) {
        return config;
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeLaunch(launch, config, this.createPreferencesLookupDelegate(launch));
            this.waitDebuggerConnected(null, launch, monitor);
        }
        catch (CoreException e) {
            launch.terminate();
            throw e;
        }
    }

    protected String getDebuggingEngineId() {
        return null;
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return this.getDebugPreferenceQualifier();
    }

    protected String getLoggingEnabledPreferenceKey() {
        return null;
    }

    protected String getLogFileNamePreferenceKey() {
        return null;
    }

    protected String getLogFilePathPreferenceKey() {
        return null;
    }
}

