/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.task.ITaskReporter;

public class ProblemCollector
extends AbstractProblemReporter
implements ITaskReporter {
    protected final List problems = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void reportProblem(IProblem problem) {
        this.problems.add(problem);
    }

    public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) {
        this.reportProblem(new TaskInfo(message, lineNumber, priority, charStart, charEnd));
    }

    public boolean isEmpty() {
        return this.problems.isEmpty();
    }

    public Object getAdapter(Class adapter) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.compiler.task.ITaskReporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(adapter)) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.dltk.compiler.problem.IProblemReporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.equals(adapter)) break block12;
            }
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean hasErrors() {
        if (!this.problems.isEmpty()) {
            Iterator i = this.problems.iterator();
            while (i.hasNext()) {
                IProblem problem = (IProblem)i.next();
                if (!problem.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public void copyTo(IProblemReporter destination) {
        Iterator i = this.problems.iterator();
        while (i.hasNext()) {
            IProblem problem = (IProblem)i.next();
            destination.reportProblem(problem);
        }
    }

    public List getErrors() {
        ArrayList<IProblem> result = new ArrayList<IProblem>();
        Iterator i = this.problems.iterator();
        while (i.hasNext()) {
            IProblem problem = (IProblem)i.next();
            if (!problem.isError()) continue;
            result.add(problem);
        }
        return result;
    }

    protected static class TaskInfo
    extends CategorizedProblem {
        private final String message;
        private final int charStart;
        private final int lineNumber;
        private final int charEnd;
        private final int priority;

        public TaskInfo(String message, int lineNumber, int priority, int charStart, int charEnd) {
            this.message = message;
            this.lineNumber = lineNumber;
            this.priority = priority;
            this.charEnd = charEnd;
            this.charStart = charStart;
        }

        public int getCategoryID() {
            return 0;
        }

        public String getMarkerType() {
            return "org.eclipse.dltk.core.task";
        }

        public String[] getArguments() {
            return null;
        }

        public int getID() {
            return 536871362;
        }

        public String getMessage() {
            return this.message;
        }

        public String getOriginatingFileName() {
            return null;
        }

        public int getSourceEnd() {
            return this.charEnd;
        }

        public int getSourceLineNumber() {
            return this.lineNumber;
        }

        public int getSourceStart() {
            return this.charStart;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isError() {
            return false;
        }

        public boolean isWarning() {
            return false;
        }

        public void setSourceEnd(int sourceEnd) {
        }

        public void setSourceLineNumber(int lineNumber) {
        }

        public void setSourceStart(int sourceStart) {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Task");
            sb.append(' ');
            sb.append(this.lineNumber);
            sb.append('[');
            sb.append(this.charStart);
            sb.append("..");
            sb.append(this.charEnd);
            sb.append(']');
            sb.append(':');
            if (this.message != null) {
                sb.append(this.message);
            }
            return sb.toString();
        }
    }
}

