/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserExtension;
import org.eclipse.dltk.compiler.env.CompilerSourceCode;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.Messages;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceParserUtil {
    private static final String AST = "ast";
    private static final String ERRORS = "errors";
    private static boolean useASTCaching = true;

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module) {
        return SourceParserUtil.getModuleDeclaration(module, null, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, int flags) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        ISourceModuleInfoCache.ISourceModuleInfo sourceModuleInfo = sourceModuleInfoCache.get(module);
        return SourceParserUtil.getModuleDeclaration(module, reporter, sourceModuleInfo, flags);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, mifo, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags) {
        String astKey;
        String errorKey;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(module);
        if (toolkit == null) {
            return null;
        }
        ModuleDeclaration moduleDeclaration = null;
        if (mifo != null && useASTCaching) {
            ProblemCollector collector;
            errorKey = SourceParserUtil.getKey(ERRORS, flags);
            astKey = SourceParserUtil.getKey(AST, flags);
            moduleDeclaration = (ModuleDeclaration)mifo.get(astKey);
            if (moduleDeclaration != null && reporter != null && (collector = (ProblemCollector)mifo.get(errorKey)) != null) {
                collector.copyTo(reporter);
            }
        } else {
            errorKey = null;
            astKey = null;
        }
        if (moduleDeclaration == null) {
            ISourceParser sourceParser = null;
            sourceParser = DLTKLanguageManager.getSourceParser(toolkit.getNatureId());
            if (sourceParser != null) {
                ProblemCollector collector;
                block13: {
                    if (sourceParser instanceof ISourceParserExtension) {
                        ((ISourceParserExtension)((Object)sourceParser)).setFlags(flags);
                    }
                    collector = mifo != null ? new ProblemCollector() : null;
                    try {
                        char[] sourceAsCharArray = module.getSourceAsCharArray();
                        moduleDeclaration = sourceParser.parse(module.getPath().toString().toCharArray(), sourceAsCharArray, collector != null ? collector : reporter);
                        if (collector != null && reporter != null) {
                            collector.copyTo(reporter);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block13;
                        String msg = Messages.SourceParserUtil_errorRetrievingContent;
                        DLTKCore.error(msg, (Throwable)((Object)e));
                    }
                }
                if (moduleDeclaration != null && mifo != null && useASTCaching) {
                    mifo.put(astKey, moduleDeclaration);
                    if (collector != null && !collector.isEmpty()) {
                        mifo.put(errorKey, collector);
                    } else {
                        mifo.remove(errorKey);
                    }
                }
            }
        }
        return moduleDeclaration;
    }

    private static String getKey(String baseKey, int flags) {
        return flags == 0 ? baseKey : String.valueOf(baseKey) + flags;
    }

    public static ModuleDeclaration getModuleDeclaration(char[] filename, char[] content, String nature, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        return SourceParserUtil.getModuleDeclaration(filename, content, nature, reporter, mifo, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(char[] filename, char[] content, String nature, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags) {
        ModuleDeclaration moduleDeclaration;
        ISourceParser sourceParser = DLTKLanguageManager.getSourceParser(nature);
        if (sourceParser instanceof ISourceParserExtension) {
            ((ISourceParserExtension)((Object)sourceParser)).setFlags(flags);
        }
        if ((moduleDeclaration = SourceParserUtil.getModuleFromCache(mifo, flags, reporter)) == null) {
            ProblemCollector collector = mifo != null ? new ProblemCollector() : null;
            moduleDeclaration = sourceParser.parse(filename, content, collector != null ? collector : reporter);
            if (collector != null && reporter != null) {
                collector.copyTo(reporter);
            }
            SourceParserUtil.putModuleToCache(mifo, moduleDeclaration, flags, collector);
        }
        return moduleDeclaration;
    }

    public static ModuleDeclaration getModuleFromCache(ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags, IProblemReporter reporter) {
        if (mifo != null && useASTCaching) {
            ProblemCollector collector;
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)mifo.get(SourceParserUtil.getKey(AST, flags));
            if (moduleDeclaration != null && reporter != null && (collector = (ProblemCollector)mifo.get(SourceParserUtil.getKey(ERRORS, flags))) != null) {
                collector.copyTo(reporter);
            }
            return moduleDeclaration;
        }
        return null;
    }

    public static void putModuleToCache(ISourceModuleInfoCache.ISourceModuleInfo info, ModuleDeclaration module, int flags, ProblemCollector collector) {
        if (info != null && useASTCaching) {
            info.put(SourceParserUtil.getKey(AST, flags), module);
            String errorKey = SourceParserUtil.getKey(ERRORS, flags);
            if (collector != null && !collector.isEmpty()) {
                info.put(errorKey, collector);
            } else {
                info.remove(errorKey);
            }
        }
    }

    public static void parseSourceModule(ISourceModule module, ISourceElementParser parser) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        ISourceModuleInfoCache.ISourceModuleInfo mifo = sourceModuleInfoCache.get(module);
        if (module instanceof org.eclipse.dltk.compiler.env.ISourceModule) {
            parser.parseSourceModule((org.eclipse.dltk.compiler.env.ISourceModule)((Object)module), mifo);
        } else {
            try {
                parser.parseSourceModule(new CompilerSourceCode(module.getSource()), mifo);
            }
            catch (ModelException ex) {
                String msg = Messages.SourceParserUtil_errorRetrievingContent;
                DLTKCore.error(msg, (Throwable)((Object)ex));
            }
        }
    }

    public static void disableCache() {
        useASTCaching = false;
    }

    public static void enableCache() {
        useASTCaching = true;
    }

    public static void clearCache() {
        ModelManager.getModelManager().getSourceModuleInfoCache().clear();
        ModelManager.getModelManager().getFileCache().clear();
    }
}

