/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;

public abstract class SearchParticipant {
    protected SearchParticipant() {
    }

    public void beginSearching() {
    }

    public void doneSearching() {
    }

    public String getDescription() {
        return "Search participant";
    }

    public abstract SearchDocument getDocument(String var1, IProject var2);

    public abstract void indexDocument(SearchDocument var1, IPath var2);

    public abstract void locateMatches(SearchDocument[] var1, SearchPattern var2, IDLTKSearchScope var3, SearchRequestor var4, IProgressMonitor var5) throws CoreException;

    public abstract ISourceModule[] locateModules(SearchDocument[] var1, SearchPattern var2, IDLTKSearchScope var3, IProgressMonitor var4) throws CoreException;

    public void removeIndex(IPath indexLocation) {
        IndexManager manager = ModelManager.getModelManager().getIndexManager();
        manager.removeIndexPath(indexLocation);
    }

    public final void scheduleDocumentIndexing(SearchDocument document, IPath indexLocation) {
        Path documentPath = new Path(document.getPath());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object file = Model.getTarget((IContainer)root, (IPath)documentPath, true);
        Path containerPath = documentPath;
        if (file instanceof IResource) {
            containerPath = ((IResource)file).getProject().getFullPath();
        } else if (file == null) {
            containerPath = documentPath.removeLastSegments(documentPath.segmentCount() - 1);
        }
        IndexManager manager = ModelManager.getModelManager().getIndexManager();
        String osIndexLocation = indexLocation.toOSString();
        manager.ensureIndexExists(osIndexLocation, (IPath)containerPath);
        manager.scheduleDocumentIndexing(document, (IPath)containerPath, osIndexLocation, this);
    }

    public abstract IPath[] selectIndexes(SearchPattern var1, IDLTKSearchScope var2);

    public abstract IPath[] selectMixinIndexes(SearchPattern var1, IDLTKSearchScope var2);

    public abstract void skipNotMixin();

    public abstract boolean isSkipped(Index var1);
}

