/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;

public class ArchiveEntryFile
extends PlatformObject
implements IStorage {
    private String entryName;
    private String zipName;
    private IPath path;
    private IResource zipResource;

    public ArchiveEntryFile(String entryName, String zipName, IPath parentRelativePath, IResource zipResource) {
        this.entryName = entryName;
        this.zipName = zipName;
        this.path = parentRelativePath;
        this.zipResource = zipResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getContents() throws CoreException {
        try {
            ByteArrayInputStream byteArrayInputStream;
            if (ModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
            }
            ZipFile zipFile = null;
            try {
                zipFile = this.zipResource == null ? new ZipFile(this.zipName) : new ZipFile(this.zipResource.getLocation().toOSString());
                ZipEntry zipEntry = zipFile.getEntry(this.path.append(this.entryName).toString());
                if (zipEntry == null) {
                    throw new ModelException(new ModelStatus(979, this.entryName));
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
                while (true) {
                    int len;
                    if ((len = inputStream.read(buf)) <= 0) {
                        byteArrayInputStream = new ByteArrayInputStream(arrayOut.toByteArray());
                        Object var7_9 = null;
                        break;
                    }
                    arrayOut.write(buf, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                zipFile.close();
                throw throwable;
            }
            zipFile.close();
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return new Path(this.entryName);
    }

    public String getName() {
        return new Path(this.entryName).lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
    }
}

