/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    protected Job progressJob;
    private int enableCount = 1;
    public static final boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public void disable() {
        --this.enableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String jobFamily) {
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (true) {
                    block17: {
                        if (i <= this.jobEnd) break block17;
                        this.jobStart = 0;
                        this.jobEnd = loc;
                        break;
                    }
                    currentJob = this.awaitingJobs[i];
                    if (currentJob != null) {
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            currentJob.cancel();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.enable();
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.enable();
            return;
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob request) {
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * Exception decompiling
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract String processName();

    public void waitUntilReady() {
        this.performConcurrentJob(new WaitJob(), 3, null);
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            this.progressJob = null;
            while (true) {
                if (this.processingThread == null) {
                    return;
                }
                try {
                    IJob job;
                    JobManager jobManager = this;
                    synchronized (jobManager) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        job = this.currentJob();
                        if (job == null) {
                            if (this.progressJob != null) {
                                this.progressJob.cancel();
                                this.progressJob = null;
                            }
                            if (idlingStart < 0L) {
                                idlingStart = System.currentTimeMillis();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            }
                            this.wait();
                        } else {
                            idlingStart = -1L;
                        }
                    }
                    if (job == null) {
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        Thread.sleep(500L);
                        continue;
                    }
                    try {
                        this.executing = true;
                        if (this.progressJob == null) {
                            class ProgressJob
                            extends Job {
                                final /* synthetic */ JobManager this$0;

                                ProgressJob(JobManager jobManager, String name) {
                                    super(name);
                                    this.this$0 = jobManager;
                                }

                                protected IStatus run(IProgressMonitor monitor) {
                                    int awaitingJobsCount;
                                    monitor.beginTask(Messages.manager_indexingTask, -1);
                                    while (!monitor.isCanceled() && (awaitingJobsCount = this.this$0.awaitingJobsCount()) > 0) {
                                        monitor.subTask(Messages.bind(Messages.manager_filesToIndex, Integer.toString(awaitingJobsCount)));
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    monitor.done();
                                    return Status.OK_STATUS;
                                }
                            }
                            this.progressJob = new ProgressJob(this, Messages.manager_indexingInProgress);
                            this.progressJob.setPriority(30);
                            this.progressJob.setSystem(true);
                            this.progressJob.schedule();
                        }
                        job.execute(null);
                    }
                    catch (Throwable throwable) {
                        jobManager = null;
                        this.executing = false;
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) throw throwable;
                        Thread.sleep(50L);
                        throw throwable;
                    }
                    {
                        jobManager = null;
                        this.executing = false;
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread == null) throw e;
            Util.log(e, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            throw e;
        }
        catch (Error e) {
            if (this.processingThread == null) throw e;
            if (e instanceof ThreadDeath) throw e;
            Util.log(e, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.processingThread;
        try {
            Job job;
            if (thread != null) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            if ((job = this.progressJob) != null) {
                job.cancel();
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private static final class WaitJob
    implements IJob {
        private WaitJob() {
        }

        public boolean belongsTo(String jobFamily) {
            return false;
        }

        public void cancel() {
        }

        public void ensureReadyToRun() {
        }

        public boolean execute(IProgressMonitor progress) {
            return false;
        }

        public String toString() {
            return "WAIT-UNTIL-READY-JOB";
        }
    }
}

