/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidParameterException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.utils.Messages;
import org.eclipse.osgi.service.datalocation.Location;

public class PlatformFileUtils {
    public static IFileHandle findAbsoluteOrEclipseRelativeFile(IEnvironment env, IPath path) {
        IFileHandle file;
        block12: {
            if (path == null || path.isEmpty()) {
                throw new InvalidParameterException(Messages.PlatformFileUtils_pathMustNotBeEmpty);
            }
            file = env.getFile(path);
            if (!env.getId().equals("org.eclipse.dltk.core.environment.localEnvironment")) {
                return file;
            }
            if (EnvironmentManager.isLocal(env) && !file.exists() && !path.isAbsolute()) {
                IFileHandle nfile;
                String loc;
                Location location;
                block11: {
                    location = Platform.getInstallLocation();
                    if (location != null) {
                        try {
                            loc = FileLocator.resolve((URL)location.getURL()).getPath();
                            nfile = env.getFile((IPath)new Path(String.valueOf(loc) + env.getSeparator() + path.toOSString()));
                            if (nfile.exists()) {
                                return nfile;
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block11;
                            e.printStackTrace();
                        }
                    }
                }
                if ((location = Platform.getInstanceLocation()) != null) {
                    try {
                        loc = FileLocator.resolve((URL)location.getURL()).getPath();
                        nfile = env.getFile((IPath)new Path(String.valueOf(loc) + env.getSeparator() + path.toOSString()));
                        if (nfile.exists()) {
                            return nfile;
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block12;
                        e.printStackTrace();
                    }
                }
            }
        }
        return file;
    }

    public static File findAbsoluteOrEclipseRelativeFile(File file) {
        return file;
    }
}

