/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.eclipse.wst.wsdl.ui.internal.actions.RenameAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBaseParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Node;

public class SmartRenameAction
extends BaseNodeAction
implements Runnable {
    protected Object element;
    protected String newName;
    private List messageReferences;
    protected Node node;
    private boolean renameParent = true;
    private String oldName;

    public SmartRenameAction(Object element, String newName) {
        this.setText("Smart Rename Action");
        this.element = element;
        this.newName = newName;
        this.node = WSDLEditorUtil.getInstance().getNodeForObject(element);
    }

    public Node getNode() {
        return this.node;
    }

    public String getUndoDescription() {
        return Messages._UI_ACTION_RENAME;
    }

    public void run(boolean renameParent) {
        this.renameParent = renameParent;
        this.run();
    }

    public void run() {
        this.beginRecording();
        if (this.element instanceof Operation) {
            EList faults;
            String oldMessageName;
            Message msg;
            Operation operation = (Operation)this.element;
            this.oldName = operation.getName();
            if (this.oldName.equals(this.newName)) {
                return;
            }
            if (this.renameParent) {
                RenameAction renamer = new RenameAction(operation, this.newName);
                renamer.run();
            }
            Input input = operation.getEInput();
            Output output = operation.getEOutput();
            WSDLElement wsdlElement = operation.getContainer();
            if (wsdlElement instanceof PortType) {
                PortType portType = (PortType)wsdlElement;
                Map bindings = portType.getEnclosingDefinition().getBindings();
                Collection values = bindings.values();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    BindingOperation bindingOperation;
                    Binding binding = (Binding)iterator.next();
                    if (!portType.equals(binding.getPortType())) continue;
                    String operationInputName = null;
                    String operationOutputName = null;
                    if (operation.getInput() != null) {
                        operationInputName = operation.getInput().getName();
                    }
                    if (operation.getOutput() != null) {
                        operationOutputName = operation.getOutput().getName();
                    }
                    if ((bindingOperation = binding.getBindingOperation(operation.getName(), operationInputName, operationOutputName)) == null) continue;
                    List extensibilityElements = bindingOperation.getExtensibilityElements();
                    Iterator extensibilityElementsIterator = extensibilityElements.iterator();
                    while (extensibilityElementsIterator.hasNext()) {
                        Object object = extensibilityElementsIterator.next();
                        if (!(object instanceof SOAPOperation)) continue;
                        SOAPOperation soapOperation = (SOAPOperation)object;
                        String soapActionURI = soapOperation.getSoapActionURI();
                        String tns = operation.getEnclosingDefinition().getTargetNamespace();
                        if (!this.computeSOAPActionURI(tns, this.oldName).equals(soapActionURI)) continue;
                        String newSOAPActionURI = soapActionURI.substring(0, soapActionURI.length() - this.oldName.length());
                        newSOAPActionURI = String.valueOf(newSOAPActionURI) + this.newName;
                        soapOperation.setSoapActionURI(newSOAPActionURI);
                    }
                }
            }
            if (input != null && input.getEMessage() != null) {
                msg = input.getEMessage();
                oldMessageName = "";
                if (msg != null && SmartRenameAction.isMessageNameGenerated(oldMessageName = msg.getQName().getLocalPart(), this.oldName, "Request")) {
                    this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                    if (msg.getEParts() != null) {
                        this.renamePartsHelper((List)msg.getEParts(), oldMessageName, msg.getQName().getLocalPart(), true);
                    }
                }
            }
            if (output != null && output.getMessage() != null) {
                msg = output.getEMessage();
                oldMessageName = "";
                if (msg != null && SmartRenameAction.isMessageNameGenerated(oldMessageName = msg.getQName().getLocalPart(), this.oldName, "Response")) {
                    this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                    if (msg.getEParts() != null) {
                        this.renamePartsHelper((List)msg.getEParts(), oldMessageName, msg.getQName().getLocalPart(), true);
                    }
                }
            }
            if ((faults = operation.getEFaults()) != null) {
                Iterator it = faults.iterator();
                while (it.hasNext()) {
                    Fault fault = (Fault)it.next();
                    msg = fault.getEMessage();
                    String oldMessageName2 = "";
                    if (msg == null || !SmartRenameAction.isMessageNameGenerated(oldMessageName2 = msg.getQName().getLocalPart(), this.oldName, fault.getName())) continue;
                    this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                    if (msg.getEParts() == null) continue;
                    this.renamePartsHelper((List)msg.getEParts(), oldMessageName2, msg.getQName().getLocalPart(), true);
                }
            }
        } else if (this.element instanceof Input) {
            Input input = (Input)this.element;
            this.oldName = input.getName();
            if (this.oldName == null) {
                this.oldName = "";
            }
            if (this.oldName.equals(this.newName)) {
                return;
            }
            if (this.renameParent) {
                input.setName(this.newName);
            }
            if (input != null && input.getEMessage() != null) {
                Message msg = input.getEMessage();
                String oldMessageName = "";
                if (msg != null && SmartRenameAction.isMessageNameGenerated(oldMessageName = msg.getQName().getLocalPart(), this.oldName, "Request")) {
                    this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                    if (msg.getEParts() != null) {
                        this.renamePartsHelper((List)msg.getEParts(), oldMessageName, msg.getQName().getLocalPart(), true);
                    }
                }
            }
        } else if (this.element instanceof Output) {
            Output output = (Output)this.element;
            this.oldName = output.getName();
            if (this.oldName == null) {
                this.oldName = "";
            }
            if (this.oldName.equals(this.newName)) {
                return;
            }
            if (this.renameParent) {
                output.setName(this.newName);
            }
            if (output != null && output.getMessage() != null) {
                Message msg = output.getEMessage();
                String oldMessageName = "";
                if (msg != null && SmartRenameAction.isMessageNameGenerated(oldMessageName = msg.getQName().getLocalPart(), this.oldName, "Response")) {
                    this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                    if (msg.getEParts() != null) {
                        this.renamePartsHelper((List)msg.getEParts(), oldMessageName, msg.getQName().getLocalPart(), true);
                    }
                }
            }
        } else if (this.element instanceof Fault) {
            Operation op;
            Fault fault = (Fault)this.element;
            Message msg = fault.getEMessage();
            String oldMessageName = "";
            this.oldName = fault.getName();
            if (this.oldName.equals(this.newName)) {
                return;
            }
            if (this.renameParent) {
                RenameAction renamer = new RenameAction(fault, this.newName);
                renamer.run();
            }
            if (msg != null && SmartRenameAction.isMessageNameGenerated(oldMessageName = msg.getQName().getLocalPart(), (op = (Operation)fault.eContainer()).getName(), this.oldName)) {
                this.renameMessageHelper(msg, this.computeNewMessageName(msg, this.oldName, this.newName));
                if (msg.getEParts() != null) {
                    this.renameFaultParts((List)msg.getEParts(), op.getName(), this.oldName, this.newName);
                }
            }
        } else if (this.element instanceof Message) {
            Message msg = (Message)this.element;
            this.oldName = msg.getQName().getLocalPart();
            String oldMessageName = msg.getQName().getLocalPart();
            if (this.oldName.equals(this.newName)) {
                return;
            }
            String newMessageName = this.computeNewMessageName(msg, this.oldName, this.newName);
            if (this.renameParent) {
                this.renameMessageHelper(msg, newMessageName);
            }
            if (msg.getEParts() != null) {
                this.renamePartsHelper((List)msg.getEParts(), oldMessageName, newMessageName, true);
            }
        } else if (this.element instanceof Part) {
            Part part = (Part)this.element;
            String oldPartName = part.getName();
            if (oldPartName.equals(this.newName)) {
                return;
            }
            if (this.renameParent) {
                RenameAction renamer = new RenameAction(this.element, this.newName);
                renamer.run();
            }
            this.renameXSDElement(part, oldPartName, this.newName);
        } else if (this.element instanceof Port) {
            Binding binding;
            RenameAction renamer;
            Port port = (Port)this.element;
            String oldPortName = port.getName();
            if (this.renameParent) {
                renamer = new RenameAction(this.element, this.newName);
                renamer.run();
            }
            if ((binding = port.getEBinding()) != null && binding.getQName().getLocalPart().equals(oldPortName)) {
                renamer = new RenameAction(binding, this.newName);
                renamer.run();
            }
        }
        this.endRecording();
    }

    private String computeSOAPActionURI(String tns, String operationName) {
        return String.valueOf(tns) + operationName;
    }

    private void renamePartsHelper(List partsList, String oldSubString, String newSubString, boolean isInputOutput) {
        if (partsList != null) {
            Iterator pIt = partsList.iterator();
            while (pIt.hasNext()) {
                Part part = (Part)pIt.next();
                String oldPartName = part.getName();
                if (SmartRenameAction.isPartNameGenerated(oldPartName, oldSubString)) {
                    String newPartName = isInputOutput ? this.computeNewPartName(part, oldSubString, newSubString) : this.computeNewFaultPartName(part, oldSubString, newSubString);
                    RenameAction renamer = new RenameAction(part, newPartName);
                    renamer.run();
                }
                this.renameXSDElement(part, oldSubString, newSubString);
            }
        }
    }

    private void renameFaultParts(List partsList, String baseName, String oldSubString, String newSubString) {
        if (partsList != null) {
            Iterator pIt = partsList.iterator();
            while (pIt.hasNext()) {
                Part part = (Part)pIt.next();
                String oldPartName = part.getName();
                if (!this.isPartNameGenerated(oldPartName, baseName, oldSubString)) continue;
                String newPartName = this.computeNewFaultPartName(part, oldSubString, newSubString);
                RenameAction renamer = new RenameAction(part, newPartName);
                renamer.run();
                this.renameXSDElement(part, oldPartName, newPartName);
            }
        }
    }

    private String computeNewMessageName(Message message, String oldSubString, String newSubString) {
        String string = message.getQName().getLocalPart();
        return this.replaceSectionWithSubString(string, oldSubString, newSubString, 0);
    }

    private String computeNewPartName(Part part, String oldSubString, String newSubString) {
        String string = part.getName();
        return this.replaceSectionWithSubString(string, oldSubString, newSubString, 0);
    }

    private String computeNewFaultPartName(Part part, String oldSubString, String newSubString) {
        String string = part.getName();
        return this.replaceSectionWithSubString(string, oldSubString, newSubString, 1);
    }

    private String replaceSectionWithSubString(String fullString, String oldSubString, String newSubString, int startSearchIndex) {
        StringBuffer fullSB = new StringBuffer(fullString);
        int index = fullSB.indexOf(oldSubString, startSearchIndex);
        if (index >= 0) {
            return fullSB.replace(index, index + oldSubString.length(), newSubString).toString();
        }
        return "";
    }

    private static boolean commonNameGeneratorCheck(String targetName, String baseName, String appendName) {
        String extras;
        if (!targetName.startsWith(baseName)) {
            return false;
        }
        if (appendName.trim().length() > 0 && !targetName.startsWith(appendName, baseName.length())) {
            return false;
        }
        int subLength = baseName.length() + appendName.length();
        return targetName.length() <= subLength || SmartRenameAction.isDigit(extras = targetName.substring(subLength));
    }

    public static boolean isOperationNameGenerated(String opName, String name) {
        return opName.equals(name);
    }

    public static boolean isMessageNameGenerated(String msgName, String baseName, String appendName) {
        return SmartRenameAction.commonNameGeneratorCheck(msgName, baseName, appendName);
    }

    public static boolean isInputOutputNameGenerated(String inOutName, String name) {
        return inOutName.equals(name);
    }

    public static boolean isFaultNameGenerated(String faultName, String name) {
        return faultName.equals(name);
    }

    public static boolean isPartNameGenerated(String partName, String baseName) {
        return SmartRenameAction.commonNameGeneratorCheck(partName, baseName, "");
    }

    private boolean isPartNameGenerated(String partName, String baseName, String appendName) {
        return SmartRenameAction.commonNameGeneratorCheck(partName, baseName, appendName);
    }

    private static boolean isDigit(String string) {
        boolean rValue = true;
        char[] chars = string.toCharArray();
        int index = 0;
        while (index < chars.length) {
            if (!Character.isDigit(chars[index])) {
                rValue = false;
                break;
            }
            ++index;
        }
        return rValue;
    }

    private void renameMessageHelper(Message msg, String newName) {
        List messageRefs = this.getReferencingMessageReferences(msg, this.getAllMessageReferences());
        RenameAction renamer = new RenameAction(msg, newName);
        renamer.run();
        Iterator iterator = messageRefs.iterator();
        while (iterator.hasNext()) {
            MessageReference messageReference = (MessageReference)iterator.next();
            messageReference.setEMessage(msg);
        }
    }

    private List getReferencingMessageReferences(Message msg, List messageRefs) {
        Vector<MessageReference> referencesVector = new Vector<MessageReference>();
        QName messageQName = msg.getQName();
        Iterator iterator = messageRefs.iterator();
        while (iterator.hasNext()) {
            MessageReference messageReference = (MessageReference)iterator.next();
            if (messageReference.getEMessage() == null || !messageQName.equals(messageReference.getEMessage().getQName())) continue;
            referencesVector.addElement(messageReference);
        }
        return referencesVector;
    }

    private List getAllMessageReferences() {
        if (this.messageReferences == null) {
            this.messageReferences = new Vector();
            Definition definition = ((WSDLElement)this.element).getEnclosingDefinition();
            EList portTypes = definition.getEPortTypes();
            if (portTypes != null) {
                Iterator portTypeIterator = portTypes.iterator();
                while (portTypeIterator.hasNext()) {
                    EList operationsList = ((PortType)portTypeIterator.next()).getEOperations();
                    if (operationsList == null) continue;
                    Iterator operationsIterator = operationsList.iterator();
                    while (operationsIterator.hasNext()) {
                        this.messageReferences.addAll(this.getAllMessageReferences((Operation)operationsIterator.next()));
                    }
                }
            }
        }
        return this.messageReferences;
    }

    private Vector getAllMessageReferences(Operation operation) {
        Vector iofs = new Vector();
        Iterator it = operation.getEFaults().iterator();
        while (it.hasNext()) {
            iofs.addElement(it.next());
        }
        if (iofs == null) {
            iofs = new Vector();
        }
        if (operation.getEInput() != null) {
            iofs.addElement(operation.getEInput());
        }
        if (operation.getEOutput() != null) {
            iofs.addElement(operation.getEOutput());
        }
        return iofs;
    }

    private void renameXSDElement(Part part, String oldXSDName, String newXSDName) {
        Operation operation;
        XSDElementDeclaration elementDeclaration = part.getElementDeclaration();
        if (elementDeclaration != null && elementDeclaration.getName().startsWith(oldXSDName)) {
            this.renameElementDeclarationHelper(elementDeclaration, oldXSDName, newXSDName);
            QName qname = new QName(part.getElementName().getNamespaceURI(), newXSDName);
            part.setElementName(qname);
        } else if (elementDeclaration != null && this.element instanceof Operation && AddBaseParameterCommand.getParameterPattern((WSDLElement)(operation = (Operation)this.element), true) == AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT && elementDeclaration.getName().equals(this.oldName)) {
            this.renameElementDeclarationHelper(elementDeclaration, this.oldName, this.newName);
            QName qname = new QName(part.getElementName().getNamespaceURI(), this.newName);
            part.setElementName(qname);
        }
    }

    private void renameElementDeclarationHelper(XSDElementDeclaration elementDeclaration, String oldXSDName, String newXSDName) {
        if (elementDeclaration != null && elementDeclaration.getName().startsWith(oldXSDName)) {
            String newElementName = this.replaceSectionWithSubString(elementDeclaration.getName(), oldXSDName, newXSDName, 0);
            elementDeclaration.setName(newElementName);
        }
    }
}

