/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectLaunchModesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectLaunchersDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LaunchConfigurationTabGroupViewer
extends Viewer {
    private ILaunchConfigurationDialog fDialog;
    private Object fInput;
    private ILaunchConfiguration fOriginal;
    private ILaunchConfigurationWorkingCopy fWorkingCopy;
    private Composite fViewerControl;
    private Composite fVisibleArea;
    private Label fNameLabel;
    private Text fNameWidget;
    private Composite fTabComposite;
    private CTabFolder fTabFolder;
    private ILaunchConfigurationTabGroup fTabGroup;
    private ILaunchConfigurationType fTabType;
    private int fCurrentTabIndex = -1;
    private Button fApplyButton;
    private Button fRevertButton;
    private boolean fDisposingTabs = false;
    private boolean fInitializingTabs = false;
    private String fDescription = null;
    private Composite fTabPlaceHolder = null;
    private Link fOptionsLink = null;
    private Composite fGettingStarted = null;
    private ViewForm fViewform;

    public LaunchConfigurationTabGroupViewer(Composite parent, ILaunchConfigurationDialog dialog) {
        this.fDialog = dialog;
        this.createControl(parent);
    }

    public void dispose() {
        this.disposeTabGroup();
    }

    protected void disposeTabGroup() {
        if (this.fTabGroup != null) {
            this.fTabGroup.dispose();
            this.fTabGroup = null;
            this.fTabType = null;
        }
    }

    private void createControl(Composite parent) {
        this.fViewerControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fViewerControl.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.fViewerControl.setLayoutData((Object)gd);
        this.fViewform = new ViewForm(this.fViewerControl, 0x800800);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fViewform.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.fViewform.setLayoutData((Object)gd);
        this.fVisibleArea = this.fViewform;
        this.fViewform.setTopLeft(null);
        Composite mainComp = new Composite((Composite)this.fViewform, 0x800000);
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        mainComp.setLayout((Layout)layout);
        this.fViewform.setContent((Control)mainComp);
        this.fTabPlaceHolder = new Composite(mainComp, 0);
        this.fTabPlaceHolder.setLayout((Layout)new StackLayout());
        gd = new GridData(1808);
        this.fTabPlaceHolder.setLayoutData((Object)gd);
        this.fGettingStarted = new Composite(this.fTabPlaceHolder, 0);
        this.fGettingStarted.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        this.fGettingStarted.setLayoutData((Object)gd);
        this.createGettingStarted(this.fGettingStarted);
        this.fTabComposite = new Composite(this.fTabPlaceHolder, 0);
        layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        this.fTabComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.fTabComposite.setLayoutData((Object)gd);
        this.fNameLabel = new Label(this.fTabComposite, 16640);
        this.fNameLabel.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog__Name__16);
        this.fNameLabel.setLayoutData((Object)new GridData(32));
        this.fNameWidget = new Text(this.fTabComposite, 2052);
        this.fNameWidget.setLayoutData((Object)new GridData(768));
        this.fNameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!LaunchConfigurationTabGroupViewer.this.fInitializingTabs) {
                    LaunchConfigurationTabGroupViewer.this.handleNameModified();
                }
            }
        });
        this.createTabFolder(this.fTabComposite);
        Composite blComp = SWTFactory.createComposite(mainComp, mainComp.getFont(), 2, 1, 768);
        Composite linkComp = SWTFactory.createComposite(blComp, blComp.getFont(), 1, 1, 768);
        this.fOptionsLink = new Link(linkComp, 64);
        this.fOptionsLink.setFont(linkComp.getFont());
        gd = new GridData(16384);
        gd.grabExcessHorizontalSpace = true;
        this.fOptionsLink.setLayoutData((Object)gd);
        this.fOptionsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SelectLaunchersDialog sldd;
                    if (!LaunchConfigurationTabGroupViewer.this.canLaunchWithModes()) {
                        Object[] res;
                        SelectLaunchModesDialog sld = new SelectLaunchModesDialog(LaunchConfigurationTabGroupViewer.this.getShell(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode(), (ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.getWorkingCopy());
                        if (sld.open() == 0 && (res = sld.getResult()) != null) {
                            Set modes = (Set)res[0];
                            modes.remove(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                            ILaunchConfigurationWorkingCopy wc = LaunchConfigurationTabGroupViewer.this.getWorkingCopy();
                            wc.setModes(modes);
                            LaunchConfigurationTabGroupViewer.this.refreshStatus();
                        }
                    } else if (LaunchConfigurationTabGroupViewer.this.hasMultipleDelegates() && (sldd = new SelectLaunchersDialog(LaunchConfigurationTabGroupViewer.this.getShell(), LaunchConfigurationTabGroupViewer.this.getWorkingCopy().getType().getDelegates(LaunchConfigurationTabGroupViewer.this.getCurrentModeSet()), LaunchConfigurationTabGroupViewer.this.getWorkingCopy(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode())).open() == 0) {
                        LaunchConfigurationTabGroupViewer.this.displayInstanceTabs(true);
                        LaunchConfigurationTabGroupViewer.this.refreshStatus();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
        this.fOptionsLink.setVisible(false);
        Composite buttonComp = new Composite(blComp, 0);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.numColumns = 2;
        buttonComp.setLayout((Layout)buttonCompLayout);
        gd = new GridData(128);
        buttonComp.setLayoutData((Object)gd);
        this.fApplyButton = new Button(buttonComp, 8);
        this.fApplyButton.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog__Apply_17);
        gd = new GridData(128);
        this.fApplyButton.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(this.fApplyButton);
        this.fApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleApplyPressed();
            }
        });
        this.fRevertButton = new Button(buttonComp, 8);
        this.fRevertButton.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog_Revert_2);
        gd = new GridData(128);
        this.fRevertButton.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(this.fRevertButton);
        this.fRevertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleRevertPressed();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    private void createGettingStarted(Composite parent) {
        Font font = parent.getFont();
        GridData gd = null;
        int width = parent.getBounds().width - 30;
        SWTFactory.createWrapLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_1, 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_2, DebugUITools.getImage("IMG_ELCL_NEW_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_6, DebugUITools.getImage("IMG_ELCL_DUPLICATE_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_4, DebugUITools.getImage("IMG_ELCL_DELETE_CONFIG"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_8, DebugUITools.getImage("IMG_ELCL_FILTER_CONFIGS"), 1, width);
        SWTFactory.createWrapCLabel(parent, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_3, DebugUITools.getImage("IMG_OVR_TRANSPARENT"), 1, width);
        SWTFactory.createHorizontalSpacer(parent, 2);
        Link link = new Link(parent, 16448);
        link.setText(LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_5);
        link.setFont(font);
        gd = new GridData(768);
        gd.widthHint = width;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.PerspectivePreferencePage");
            }
        });
    }

    private void createTabFolder(Composite parent) {
        if (this.fTabFolder == null) {
            ColorRegistry reg = JFaceResources.getColorRegistry();
            Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            this.fTabFolder = new CTabFolder(parent, 0x900008);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.fTabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
            this.fTabFolder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
            this.fTabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            this.fTabFolder.setLayoutData((Object)gd);
            this.fTabFolder.setBorderVisible(true);
            this.fTabFolder.setFont(parent.getFont());
            this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!LaunchConfigurationTabGroupViewer.this.fInitializingTabs) {
                        LaunchConfigurationTabGroupViewer.this.handleTabSelected();
                        LaunchConfigurationTabGroupViewer.this.refresh();
                    }
                }
            });
        }
    }

    protected Button getApplyButton() {
        return this.fApplyButton;
    }

    protected Button getRevertButton() {
        return this.fRevertButton;
    }

    protected CTabFolder getTabFolder() {
        return this.fTabFolder;
    }

    public void setName(String name) {
        if (this.getWorkingCopy() != null) {
            if (name == null) {
                this.fNameWidget.setText("");
            } else {
                this.fNameWidget.setText(name.trim());
            }
            this.refreshStatus();
        }
    }

    public Control getControl() {
        return this.fViewerControl;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.fWorkingCopy);
    }

    public void refresh() {
        if (this.fInitializingTabs) {
            return;
        }
        if (this.fOriginal != null && this.fOriginal.isReadOnly()) {
            this.updateButtons();
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs != null) {
            boolean newwc = !this.getWorkingCopy().isDirty();
            this.getActiveTab().performApply(this.getWorkingCopy());
            if (this.fOriginal instanceof ILaunchConfigurationWorkingCopy && newwc) {
                try {
                    ILaunchConfigurationWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        copy.doSave();
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            this.updateButtons();
            CTabItem item = null;
            boolean error = false;
            Image image = null;
            int i = 0;
            while (i < tabs.length) {
                item = this.fTabFolder.getItem(i);
                image = tabs[i].getImage();
                item.setImage(image);
                if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                    boolean bl = error = tabs[i].getErrorMessage() != null;
                    if (error) {
                        item.setImage(DebugUIPlugin.getDefault().getLaunchConfigurationManager().getErrorTabImage(tabs[i]));
                    }
                }
                ++i;
            }
            this.showLink();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    private void showLink() {
        String text = null;
        if (!this.canLaunchWithModes()) {
            text = LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_13;
        } else if (this.hasMultipleDelegates()) {
            String name;
            ILaunchDelegate delegate = this.getPreferredDelegate();
            text = delegate != null ? ((name = delegate.getName()) == null ? LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_15 : MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_16, (Object[])new String[]{name})) : LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_17;
        }
        if (text != null) {
            this.fOptionsLink.setText(text);
        }
        this.fOptionsLink.setVisible(!this.canLaunchWithModes() || this.hasMultipleDelegates());
        this.fViewform.layout(true, true);
    }

    protected ILaunchDelegate getPreferredDelegate() {
        ILaunchDelegate preferred = null;
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                Set modes = this.getCurrentModeSet();
                preferred = config.getPreferredDelegate(modes);
                if (preferred == null) {
                    preferred = config.getType().getPreferredDelegate(modes);
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return preferred;
    }

    private Set getCurrentModeSet() {
        HashSet<String> set = new HashSet<String>();
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                set.addAll(config.getModes());
                set.add(this.getLaunchConfigurationDialog().getMode());
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return set;
    }

    private void updateButtons() {
        boolean dirty = this.isDirty() && this.canSave();
        this.fApplyButton.setEnabled(dirty);
        this.fRevertButton.setEnabled(dirty);
    }

    public void setInput(final Object input) {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            this.setInput0(input);
        } else {
            DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    LaunchConfigurationTabGroupViewer.this.setInput0(input);
                }
            });
        }
    }

    private void setInput0(Object input) {
        if (input == null) {
            if (this.fInput == null) {
                return;
            }
            this.inputChanged(input);
        } else if (!input.equals(this.fInput)) {
            this.inputChanged(input);
        }
    }

    protected void inputChanged(Object input) {
        this.fInput = input;
        Runnable r = new Runnable(){

            public void run() {
                block7: {
                    try {
                        try {
                            LaunchConfigurationTabGroupViewer.this.fVisibleArea.setRedraw(false);
                            if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfiguration) {
                                ILaunchConfiguration configuration = (ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.fInput;
                                boolean refreshtabs = !LaunchConfigurationTabGroupViewer.this.delegatesEqual((ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.fWorkingCopy, configuration);
                                LaunchConfigurationTabGroupViewer.this.fOriginal = configuration;
                                LaunchConfigurationTabGroupViewer.this.fWorkingCopy = configuration.getWorkingCopy();
                                LaunchConfigurationTabGroupViewer.this.displayInstanceTabs(refreshtabs);
                                break block7;
                            }
                            if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfigurationType) {
                                LaunchConfigurationTabGroupViewer.this.fDescription = LaunchConfigurationTabGroupViewer.this.getDescription((ILaunchConfigurationType)LaunchConfigurationTabGroupViewer.this.fInput);
                                LaunchConfigurationTabGroupViewer.this.setNoInput();
                                break block7;
                            }
                            LaunchConfigurationTabGroupViewer.this.setNoInput();
                        }
                        catch (CoreException ce) {
                            LaunchConfigurationTabGroupViewer.this.errorDialog(ce);
                            LaunchConfigurationTabGroupViewer.this.setNoInput();
                            LaunchConfigurationTabGroupViewer.this.refreshStatus();
                            LaunchConfigurationTabGroupViewer.this.fVisibleArea.setRedraw(true);
                        }
                    }
                    finally {
                        LaunchConfigurationTabGroupViewer.this.refreshStatus();
                        LaunchConfigurationTabGroupViewer.this.fVisibleArea.setRedraw(true);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    private void setNoInput() {
        this.fOriginal = null;
        this.fWorkingCopy = null;
        this.disposeExistingTabs();
        this.updateButtons();
        this.updateVisibleControls(false);
        ILaunchConfigurationDialog lcd = this.getLaunchConfigurationDialog();
        if (lcd instanceof LaunchConfigurationsDialog && ((LaunchConfigurationsDialog)lcd).isTreeSelectionEmpty()) {
            this.fDescription = "";
        }
    }

    protected boolean delegatesEqual(ILaunchConfiguration config1, ILaunchConfiguration config2) {
        block6: {
            if (config1 != null && config2 != null) break block6;
            return false;
        }
        try {
            ILaunchDelegate d2;
            Set modes = this.getCurrentModeSet();
            ILaunchDelegate d1 = config1.getPreferredDelegate(modes);
            if (d1 == null) {
                d1 = config1.getType().getPreferredDelegate(modes);
            }
            if ((d2 = config2.getPreferredDelegate(modes)) == null) {
                d2 = config2.getType().getPreferredDelegate(modes);
            }
            if (d1 != null) {
                return d1.equals(d2);
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return false;
    }

    private void updateVisibleControls(boolean visible) {
        this.fApplyButton.setVisible(visible);
        this.fRevertButton.setVisible(visible);
        this.fOptionsLink.setVisible(visible);
        ((StackLayout)this.fTabPlaceHolder.getLayout()).topControl = visible ? this.fTabComposite : this.fGettingStarted;
        this.fTabPlaceHolder.layout(true, true);
    }

    protected void setFocusOnName() {
        this.fNameWidget.setFocus();
    }

    protected void displayInstanceTabs(boolean redrawTabs) {
        this.fInitializingTabs = true;
        ILaunchConfigurationType type = null;
        try {
            type = this.getWorkingCopy().getType();
        }
        catch (CoreException e) {
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        if (redrawTabs) {
            this.showInstanceTabsFor(type);
        }
        this.updateVisibleControls(true);
        ILaunchConfigurationTabGroup tabGroup = this.getTabGroup();
        if (tabGroup == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_No_tabs_defined_for_launch_configuration_type__0__1, (Object[])new String[]{type.getName()}), null);
            CoreException e = new CoreException((IStatus)status);
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        tabGroup.initializeFrom((ILaunchConfiguration)this.getWorkingCopy());
        this.fNameWidget.setText(this.getWorkingCopy().getName());
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
        this.fInitializingTabs = false;
        if (!this.fVisibleArea.isVisible()) {
            this.fVisibleArea.setVisible(true);
        }
    }

    private void showInstanceTabsFor(ILaunchConfigurationType configType) {
        Class<?> tabKind = null;
        if (this.getActiveTab() != null) {
            tabKind = this.getActiveTab().getClass();
        }
        ILaunchConfigurationTabGroup group = null;
        try {
            group = this.createGroup();
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_creating_launch_configuration_tabs_27, ce);
            return;
        }
        this.disposeExistingTabs();
        this.fTabGroup = group;
        this.fTabType = configType;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        CTabItem tab = null;
        String name = "";
        Control control = null;
        int i = 0;
        while (i < tabs.length) {
            tab = new CTabItem(this.fTabFolder, 2048);
            name = tabs[i].getName();
            if (name == null) {
                name = LaunchConfigurationsMessages.LaunchConfigurationDialog_unspecified_28;
            }
            tab.setText(name);
            tab.setImage(tabs[i].getImage());
            tabs[i].createControl((Composite)tab.getParent());
            control = tabs[i].getControl();
            if (control != null) {
                tab.setControl(control);
            }
            ++i;
        }
        this.setActiveTab(tabs[0]);
        i = 0;
        while (i < tabs.length) {
            if (tabs[i].getClass().equals(tabKind)) {
                this.setActiveTab(tabs[i]);
                break;
            }
            ++i;
        }
        this.fDescription = this.getDescription(configType);
    }

    private String getDescription(ILaunchConfigurationType configType) {
        String description = null;
        if (configType != null) {
            String mode = this.fDialog.getMode();
            description = LaunchConfigurationPresentationManager.getDefault().getDescription(configType, mode);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    protected ILaunchConfigurationTabGroup createGroup() throws CoreException {
        final Object[] finalArray = new Object[2];
        Runnable runnable = new Runnable(){

            public void run() {
                ILaunchConfigurationTabGroup tabGroup = null;
                try {
                    tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.getWorkingCopy(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                    finalArray[0] = tabGroup;
                }
                catch (CoreException ce) {
                    finalArray[1] = ce;
                    return;
                }
                tabGroup.createTabs(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].setLaunchConfigurationDialog(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog());
                    ++i;
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)runnable);
        if (finalArray[1] != null) {
            throw (CoreException)((Object)finalArray[1]);
        }
        return (ILaunchConfigurationTabGroup)finalArray[0];
    }

    public void setSelection(ISelection selection, boolean reveal) {
        ILaunchConfigurationTab[] tabs;
        int i;
        IStructuredSelection structuredSelection;
        Object object;
        if (this.getWorkingCopy() != null && selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ILaunchConfigurationTab && (i = 0) < (tabs = this.getTabs()).length) {
            if (tabs[i].equals(object)) {
                this.fCurrentTabIndex = i;
                this.fTabFolder.setSelection(i);
            }
            return;
        }
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() != null) {
            return this.getTabGroup().getTabs();
        }
        return null;
    }

    public ILaunchConfigurationTab getActiveTab() {
        int pageIndex;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fTabFolder != null && tabs != null && (pageIndex = this.fTabFolder.getSelectionIndex()) >= 0) {
            return tabs[pageIndex];
        }
        return null;
    }

    public boolean isDirty() {
        ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return false;
        }
        if (workingCopy.getParent() != null) {
            return !workingCopy.getParent().contentsEqual((ILaunchConfiguration)workingCopy);
        }
        if (workingCopy.getOriginal() == null) {
            return true;
        }
        return this.fOriginal != null && !this.fOriginal.contentsEqual((ILaunchConfiguration)workingCopy);
    }

    protected void refreshStatus() {
        if (!this.fInitializingTabs) {
            LaunchConfigurationsDialog lcd = (LaunchConfigurationsDialog)this.getLaunchConfigurationDialog();
            lcd.refreshStatus();
        }
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fDialog;
    }

    protected ILaunchConfiguration getOriginal() {
        return this.fOriginal;
    }

    protected ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public boolean canSave() {
        if (this.fInitializingTabs) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].canSave()) {
                return false;
            }
            ++i;
        }
        if (this.getWorkingCopy() != null) {
            return !this.getWorkingCopy().isReadOnly();
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.fInitializingTabs) {
            return false;
        }
        if (this.getWorkingCopy() == null) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canLaunchWithModes() {
        if (this.fInitializingTabs) {
            return false;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                return wc.getType().supportsModeCombination(this.getCurrentModeSet());
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public boolean hasDuplicateDelegates() {
        if (this.fInitializingTabs) {
            return false;
        }
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null && this.hasMultipleDelegates()) {
            return this.getPreferredDelegate() == null;
        }
        return false;
    }

    private boolean hasMultipleDelegates() {
        ILaunchConfigurationWorkingCopy config = this.getWorkingCopy();
        if (config != null) {
            try {
                Set modes = this.getCurrentModeSet();
                ILaunchDelegate[] delegates = LaunchConfigurationManager.filterLaunchDelegates(this.fTabType, modes);
                return delegates.length > 1;
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return false;
    }

    public String getErrorMesssage() {
        if (this.fInitializingTabs) {
            return null;
        }
        if (this.getWorkingCopy() == null) {
            return null;
        }
        try {
            this.verifyName();
        }
        catch (CoreException ce) {
            return ce.getStatus().getMessage();
        }
        String message = null;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab == null) {
            return null;
        }
        message = activeTab.getErrorMessage();
        if (message != null) {
            return message;
        }
        ILaunchConfigurationTab[] allTabs = this.getTabs();
        int i = 0;
        while (i < allTabs.length) {
            ILaunchConfigurationTab tab = allTabs[i];
            if (tab != activeTab && (message = tab.getErrorMessage()) != null) {
                StringBuffer temp = new StringBuffer();
                temp.append('[');
                temp.append(DebugUIPlugin.removeAccelerators(tab.getName()));
                temp.append("]: ");
                temp.append(message);
                return temp.toString();
            }
            ++i;
        }
        if (this.getWorkingCopy().isReadOnly()) {
            return LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_9;
        }
        if (!this.canLaunchWithModes()) {
            Set modes = this.getCurrentModeSet();
            List names = LaunchConfigurationPresentationManager.getDefault().getLaunchModeNames(modes);
            return MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_14, (Object[])new String[]{names.toString()});
        }
        if (this.hasDuplicateDelegates()) {
            return LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_18;
        }
        return null;
    }

    public String getMessage() {
        String tabMessage;
        if (this.fInitializingTabs) {
            return null;
        }
        String message = this.fDescription;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab != null && (tabMessage = tab.getMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    protected void verifyName() throws CoreException {
        if (this.fNameWidget.isVisible()) {
            int i;
            String currentName = this.fNameWidget.getText().trim();
            if (currentName.length() < 1) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_Name_required_for_launch_configuration_11, null));
            }
            if ("win32".equals(Platform.getOS())) {
                String[] badnames = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
                i = 0;
                while (i < badnames.length) {
                    if (currentName.equals(badnames[i])) {
                        throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_19, (Object[])new String[]{currentName}), null));
                    }
                    ++i;
                }
            }
            char[] cArray = new char[12];
            cArray[0] = 64;
            cArray[1] = 38;
            cArray[2] = 92;
            cArray[3] = 47;
            cArray[4] = 58;
            cArray[5] = 42;
            cArray[6] = 63;
            cArray[7] = 34;
            cArray[8] = 60;
            cArray[9] = 62;
            cArray[10] = 124;
            char[] disallowedChars = cArray;
            i = 0;
            while (i < disallowedChars.length) {
                char c = disallowedChars[i];
                if (currentName.indexOf(c) > -1) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_0, (Object[])new String[]{new String(new char[]{c})}), null));
                }
                ++i;
            }
            if (this.fOriginal != null && !this.fOriginal.getName().equals(currentName)) {
                Set reservednames = ((LaunchConfigurationsDialog)this.getLaunchConfigurationDialog()).getReservedNameSet();
                if (DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(currentName) || reservednames != null && reservednames.contains(currentName)) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_configuration_already_exists_with_this_name_12, null));
                }
            }
        }
    }

    private void disposeExistingTabs() {
        this.fDisposingTabs = true;
        this.fTabFolder.dispose();
        this.fTabFolder = null;
        this.createTabFolder(this.fTabComposite);
        this.disposeTabGroup();
        this.fDisposingTabs = false;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        return this.fTabGroup;
    }

    protected void handleTabSelected() {
        if (this.fDisposingTabs || this.fInitializingTabs) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fCurrentTabIndex == this.fTabFolder.getSelectionIndex() || tabs == null || tabs.length == 0 || this.fCurrentTabIndex > tabs.length - 1) {
            return;
        }
        if (this.fCurrentTabIndex != -1) {
            ILaunchConfigurationTab tab = tabs[this.fCurrentTabIndex];
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                tab.deactivated(wc);
                this.getActiveTab().activated(wc);
            }
        }
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
    }

    protected void handleNameModified() {
        this.getWorkingCopy().rename(this.fNameWidget.getText().trim());
        this.refreshStatus();
    }

    protected void handleApplyPressed() {
        Throwable exception = null;
        try {
            this.fInitializingTabs = true;
            String trimmed = this.fNameWidget.getText().trim();
            this.fNameWidget.setText(trimmed);
            if (this.fWorkingCopy == null) {
                this.fWorkingCopy = this.fOriginal.getWorkingCopy();
            }
            this.fWorkingCopy.rename(trimmed);
            this.getTabGroup().performApply(this.fWorkingCopy);
            if (this.isDirty()) {
                if (!this.fWorkingCopy.isLocal()) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                LaunchConfigurationTabGroupViewer.this.fOriginal = ((LaunchConfigurationWorkingCopy)LaunchConfigurationTabGroupViewer.this.fWorkingCopy).doSave(monitor);
                            }
                            catch (CoreException e) {
                                DebugUIPlugin.log(e);
                            }
                        }
                    };
                    this.getLaunchConfigurationDialog().run(true, false, runnable);
                } else {
                    this.fOriginal = this.fWorkingCopy.doSave();
                }
            }
            this.updateButtons();
            this.fInitializingTabs = false;
        }
        catch (CoreException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = e;
        }
        if (exception != null) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configuration_Error_46, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_while_saving_launch_configuration_47, exception);
            return;
        }
    }

    protected void handleRevertPressed() {
        try {
            if (this.fTabGroup != null) {
                this.fTabGroup.initializeFrom(this.fOriginal);
                this.fNameWidget.setText(this.fOriginal.getName());
                this.fWorkingCopy = this.fOriginal.getWorkingCopy();
                this.refreshStatus();
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    protected void errorDialog(CoreException exception) {
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)exception.getStatus());
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs != null) {
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i].getClass().equals(tab.getClass())) {
                    this.setActiveTab(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void setActiveTab(int index) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (index >= 0 && index < tabs.length) {
            this.fTabFolder.setSelection(index);
            this.handleTabSelected();
        }
    }
}

