/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.ui.formatter.IFormatterModifiyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.internal.FormatterControlManager;
import org.eclipse.dltk.ui.formatter.internal.FormatterDialogPreferences;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class FormatterModifyDialog
extends StatusDialog
implements IFormatterModifyDialog,
IStatusChangeListener {
    private final FormatterDialogPreferences preferences = new FormatterDialogPreferences();
    private final FormatterControlManager controlManager = new FormatterControlManager(this.preferences, this);
    private final IFormatterModifyDialogOwner dialogOwner;
    private final IScriptFormatterFactory formatterFactory;
    final IDialogSettings fDialogSettings;
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";
    private TabFolder fTabFolder;
    private final List fTabPages = new ArrayList();

    public FormatterModifyDialog(IFormatterModifyDialogOwner dialogOwner, IScriptFormatterFactory formatterFactory) {
        super(dialogOwner.getShell());
        this.dialogOwner = dialogOwner;
        this.formatterFactory = formatterFactory;
        this.fDialogSettings = FormatterModifyDialog.getDialogSettingsSection(dialogOwner.getDialogSettings(), formatterFactory.getId());
        this.setStatusLineAboveButtons(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private static IDialogSettings getDialogSettingsSection(IDialogSettings settings, String sectionId) {
        IDialogSettings section = settings.getSection(sectionId);
        if (section == null) {
            section = settings.addNewSection(sectionId);
        }
        return section;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(KEY_WIDTH);
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(KEY_HEIGHT))) {
                lastHeight = initialSize.y;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(KEY_X), this.fDialogSettings.getInt(KEY_Y));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(KEY_WIDTH, shell.width);
        this.fDialogSettings.put(KEY_HEIGHT, shell.height);
        this.fDialogSettings.put(KEY_X, shell.x);
        this.fDialogSettings.put(KEY_Y, shell.y);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPages();
        this.controlManager.initialize();
        return composite;
    }

    protected abstract void addPages();

    protected void addTabPage(String title, IFormatterModifiyTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        FormatterModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents(this.controlManager, (Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    public void statusChanged(IStatus status) {
        this.updateStatus(status);
        Iterator i = this.fTabPages.iterator();
        while (i.hasNext()) {
            IFormatterModifiyTabPage tabPage = (IFormatterModifiyTabPage)i.next();
            tabPage.updatePreview();
        }
    }

    public IFormatterModifyDialogOwner getOwner() {
        return this.dialogOwner;
    }

    public IScriptFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public void setPreferences(Map prefs) {
        this.preferences.set(prefs);
    }

    public Map getPreferences() {
        return this.preferences.get();
    }
}

