/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.Messages;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class GenericDLTKProjectWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    private ProjectWizardFirstPage fFirstPage;
    private ProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;
    private String nature;
    private String preferencePageId;

    public GenericDLTKProjectWizard() {
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.GenericDLTKProjectWizard_newDltkProject);
    }

    public String getNature() {
        return this.nature;
    }

    protected IPreferenceStore getPreferenceStoreFromNature() {
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(this.nature);
        if (languageToolkit != null) {
            return languageToolkit.getPreferenceStore();
        }
        return null;
    }

    public void addPages() {
        super.addPages();
        final String curNature = this.nature;
        final String curPreferencePageId = this.preferencePageId;
        this.fFirstPage = new ProjectWizardFirstPage(){
            GenericDLTKInterpreterGroup fInterpreterGroup;

            protected void createInterpreterGroup(Composite parent) {
                this.fInterpreterGroup = new GenericDLTKInterpreterGroup(parent, curNature, curPreferencePageId);
            }

            protected Observable getInterpreterGroupObservable() {
                return this.fInterpreterGroup;
            }

            protected boolean supportInterpreter() {
                return true;
            }

            protected IInterpreterInstall getInterpreter() {
                return this.fInterpreterGroup.getSelectedInterpreter();
            }

            protected void handlePossibleInterpreterChange() {
                this.fInterpreterGroup.handlePossibleInterpreterChange();
            }

            protected boolean interpeterRequired() {
                return false;
            }

            class GenericDLTKInterpreterGroup
            extends ProjectWizardFirstPage.AbstractInterpreterGroup {
                private final /* synthetic */ String val$curNature;
                private final /* synthetic */ String val$curPreferencePageId;

                public GenericDLTKInterpreterGroup(Composite composite, String string, String string2) {
                    this.val$curNature = string;
                    this.val$curPreferencePageId = string2;
                    super(this, composite);
                }

                protected String getCurrentLanguageNature() {
                    return this.val$curNature;
                }

                protected String getIntereprtersPreferencePageId() {
                    return this.val$curPreferencePageId;
                }
            }
        };
        this.fFirstPage.setTitle(Messages.GenericDLTKProjectWizard_newDltkProject);
        this.fFirstPage.setDescription(Messages.GenericDLTKProjectWizard_createNewDltkProject);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new ProjectWizardSecondPage(this.fFirstPage){

            protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
                return new GenericDLTKBuildpathBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
            }

            protected String getScriptNature() {
                return curNature;
            }

            protected IPreferenceStore getPreferenceStore() {
                return GenericDLTKProjectWizard.this.getPreferenceStoreFromNature();
            }
        };
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getScriptProject().getProject());
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
        if (data instanceof String) {
            this.nature = (String)data;
        } else if (data instanceof Map) {
            this.nature = (String)((Map)data).get("nature");
        }
        if (this.nature == null || this.nature.length() == 0) {
            throw new RuntimeException(Messages.GenericDLTKProjectWizard_natureMustBeSpecified);
        }
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    private class GenericDLTKBuildpathBlock
    extends BuildpathsBlock {
        public GenericDLTKBuildpathBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
            super(runnableContext, context, pageToShow, useNewPage, pageContainer);
        }

        protected IPreferenceStore getPreferenceStore() {
            return GenericDLTKProjectWizard.this.getPreferenceStoreFromNature();
        }

        protected boolean supportZips() {
            IDLTKLanguageToolkit languageToolkit = null;
            languageToolkit = DLTKLanguageManager.getLanguageToolkit((String)GenericDLTKProjectWizard.this.nature);
            if (languageToolkit != null) {
                return languageToolkit.languageSupportZIPBuildpath();
            }
            return false;
        }
    }
}

