/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ScriptStreamProxy
implements IScriptStreamProxy {
    private IOConsoleInputStream input;
    private IOConsoleOutputStream stdOut;
    private IOConsoleOutputStream stdErr;
    private boolean closed = false;

    public ScriptStreamProxy(IOConsole console) {
        this.input = console.getInputStream();
        this.stdOut = console.newOutputStream();
        this.stdErr = console.newOutputStream();
        boolean activeOnStderr = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnErr");
        boolean activeOnStdou = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnOut");
        this.stdErr.setActivateOnWrite(activeOnStderr);
        this.stdOut.setActivateOnWrite(activeOnStdou);
        Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                RGB errRGB = PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.debug.ui.errorColor");
                RGB outRGB = PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.debug.ui.outColor");
                ScriptStreamProxy.this.stdErr.setColor(DLTKDebugUIPlugin.getDefault().getColor(errRGB));
                ScriptStreamProxy.this.stdOut.setColor(DLTKDebugUIPlugin.getDefault().getColor(outRGB));
            }
        });
    }

    private Display getDisplay() {
        if (Display.getCurrent() != null) {
            return Display.getCurrent();
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return Display.getDefault();
    }

    public OutputStream getStderr() {
        return this.stdErr;
    }

    public OutputStream getStdout() {
        return this.stdOut;
    }

    public InputStream getStdin() {
        return this.input;
    }

    public synchronized void close() {
        block3: {
            if (!this.closed) {
                try {
                    this.stdOut.close();
                    this.stdErr.close();
                    this.input.close();
                    this.closed = true;
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }
}

