/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.io.IOException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.util.OpenTypeHistory;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.internal.ui.ColorManager;
import org.eclipse.php.internal.ui.InitializeAfterLoadJob;
import org.eclipse.php.internal.ui.PHPUILanguageToolkit;
import org.eclipse.php.internal.ui.PhpDemoProject;
import org.eclipse.php.internal.ui.dnd.DNDUtils;
import org.eclipse.php.internal.ui.editor.ASTProvider;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderRegistry;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.text.PHPTextTools;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPManualSiteDescriptor;
import org.eclipse.php.internal.ui.util.ProblemMarkerManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class PHPUiPlugin
extends AbstractUIPlugin {
    private static PHPUiPlugin plugin;
    private IContentFormatter fActiveFormatter = null;
    public static final String ID = "org.eclipse.php.ui";
    public static final int INTERNAL_ERROR = 10001;
    public static final boolean isDebugMode;
    public static final String PERSPECTIVE_ID = "org.eclipse.php.perspective";
    public static final char CREATE_TEST_PROJECT_SWITCH_FIRST_CHAR = '-';
    public static final char CREATE_TEST_PROJECT_SWITCH_SECOND_CHAR = 'p';
    public static final char CREATE_TEST_PROJECT_SWITCH_THIRD_CHAR = 'd';
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private ProblemMarkerManager fProblemMarkerManager;
    protected TemplateStore templateStore = null;
    protected ContextTypeRegistry contentTypeRegistry = null;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private PHPFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private PHPEditorTextHoverDescriptor[] fPHPEditorTextHoverDescriptors;
    private PHPManualSiteDescriptor[] fPHPManualSiteDescriptors;
    private ASTProvider fASTProvider;
    private ColorManager fColorManager;
    private PHPTextTools fTextTools;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.ui/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public PHPUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final BundleContext ctx = context;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DNDUtils.initEditorSiteExternalDrop();
                PHPUiPlugin.this.processCommandLine(ctx);
            }
        });
        if (PlatformUI.isWorkbenchRunning()) {
            new InitializeAfterLoadJob().schedule();
        }
    }

    static void initializeAfterLoad(IProgressMonitor monitor) {
        OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)PHPUILanguageToolkit.getInstance()).checkConsistency(monitor);
    }

    private void processCommandLine(BundleContext context) {
        ServiceTracker environmentTracker = new ServiceTracker(context, EnvironmentInfo.class.getName(), null);
        environmentTracker.open();
        EnvironmentInfo environmentInfo = (EnvironmentInfo)environmentTracker.getService();
        environmentTracker.close();
        if (environmentInfo == null) {
            return;
        }
        String[] args = environmentInfo.getNonFrameworkArgs();
        if (args == null || args.length == 0) {
            return;
        }
        int i = args.length - 1;
        while (i >= 0) {
            if (args[i].length() == 3 && '-' == args[i].charAt(0) && 'p' == args[i].charAt(1) && 'd' == args[i].charAt(2)) {
                this.createTestProject();
                return;
            }
            --i;
        }
    }

    private void createTestProject() {
        PhpDemoProject.run();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.fASTProvider = null;
        plugin = null;
    }

    public static PHPUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PHPUiPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void logErrorMessage(String message) {
        PHPUiPlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static void log(IStatus status) {
        PHPUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PHPUiPlugin.log((IStatus)new Status(4, ID, 10001, "PHP ui plugin internal error", e));
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return PHPUiPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return PHPUiPlugin.getDefault().internalGetActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = PHPUiPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new PHPTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), "org.eclipse.php.ui.editor.templates");
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contentTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("php");
            registry.addContextType("newPhp");
            registry.addContextType("phpcomment");
            this.contentTypeRegistry = registry;
        }
        return this.contentTypeRegistry;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        if (this.fMembersOrderPreferenceCache == null) {
            this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        }
        return this.fMembersOrderPreferenceCache;
    }

    public static String getPluginId() {
        return ID;
    }

    public synchronized PHPFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new PHPFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public PHPEditorTextHoverDescriptor[] getPHPEditorTextHoverDescriptors() {
        if (this.fPHPEditorTextHoverDescriptors == null) {
            this.fPHPEditorTextHoverDescriptors = PHPEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((PHPEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fPHPEditorTextHoverDescriptors);
            int i = 0;
            while (i < this.fPHPEditorTextHoverDescriptors.length - 1) {
                if ("org.eclipse.php.ui.editor.hover.BestMatchHover".equals(this.fPHPEditorTextHoverDescriptors[i].getId())) {
                    PHPEditorTextHoverDescriptor hoverDescriptor = this.fPHPEditorTextHoverDescriptors[i];
                    int j = i;
                    while (j > 0) {
                        this.fPHPEditorTextHoverDescriptors[j] = this.fPHPEditorTextHoverDescriptors[j - 1];
                        --j;
                    }
                    this.fPHPEditorTextHoverDescriptors[0] = hoverDescriptor;
                    break;
                }
                ++i;
            }
        }
        return this.fPHPEditorTextHoverDescriptors;
    }

    public void resetPHPEditorTextHoverDescriptors() {
        this.fPHPEditorTextHoverDescriptors = null;
    }

    public PHPManualSiteDescriptor[] getPHPManualSiteDescriptors() {
        if (this.fPHPManualSiteDescriptors == null) {
            this.fPHPManualSiteDescriptors = PHPManualSiteDescriptor.getContributedSites();
        }
        return this.fPHPManualSiteDescriptors;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public synchronized ColorManager getColorManager() {
        if (this.fColorManager == null) {
            this.fColorManager = new ColorManager();
        }
        return this.fColorManager;
    }

    public synchronized PHPTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new PHPTextTools(true);
        }
        return this.fTextTools;
    }

    public static ISourceModule getEditorInputTypeRoot(IEditorInput editorInput) {
        ISourceModule cu = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (cu != null) {
            return cu;
        }
        ISourceModule je = (ISourceModule)editorInput.getAdapter(ISourceModule.class);
        return je;
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return DLTKUIPlugin.getDefault().getWorkingCopyManager();
    }

    public IContentFormatter getActiveFormatter() {
        if (this.fActiveFormatter == null) {
            String formatterExtensionName = "org.eclipse.php.ui.phpFormatterProcessor";
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(formatterExtensionName);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals("processor")) {
                    ElementCreationProxy ecProxy = new ElementCreationProxy(element, formatterExtensionName);
                    this.fActiveFormatter = (IContentFormatter)ecProxy.getObject();
                }
                ++i;
            }
            if (this.fActiveFormatter == null) {
                this.fActiveFormatter = new MultiPassContentFormatter("org.eclipse.wst.sse.core.default_structured_text_partitioning", "org.eclipse.wst.html.HTML_DEFAULT");
                ((MultiPassContentFormatter)this.fActiveFormatter).setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
            }
        }
        return this.fActiveFormatter;
    }
}

