/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.typehierarchy.OpenTypeHierarchyUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction
implements IUpdate {
    private PHPStructuredEditor fEditor;
    private IModelElement lastSelectedElement;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText("Open &Type Hierarchy");
        this.setToolTipText("Open &Type Hierarchy");
        this.setDescription("Open &Type Hierarchy");
    }

    public OpenTypeHierarchyAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            this.setEnabled(false);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else if (selection instanceof ITreeSelection) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IMethod) {
                this.setEnabled(((IMethod)firstElement).getParent() instanceof IType);
            } else {
                this.setEnabled(firstElement instanceof IType || firstElement instanceof IField);
            }
        }
    }

    private boolean isEnabled(ITextSelection selection) {
        if (this.fEditor == null || selection == null) {
            return false;
        }
        if (this.fEditor.getModelElement() instanceof ISourceModule) {
            ISourceModule sourceModule = (ISourceModule)this.fEditor.getModelElement();
            IModelElement element = this.getSelectionModelElement(selection.getOffset(), selection.getLength(), sourceModule);
            if (element == null) {
                this.lastSelectedElement = null;
                return false;
            }
            switch (element.getElementType()) {
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    this.lastSelectedElement = element;
                    return true;
                }
            }
        }
        this.lastSelectedElement = null;
        return false;
    }

    protected IModelElement getSelectionModelElement(int offset, int length, ISourceModule sourceModule) {
        IModelElement element = null;
        try {
            ASTNode selectedNode;
            Program ast = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_NO, null);
            if (ast != null && (selectedNode = NodeFinder.perform((ASTNode)ast, offset, length)).getType() == 33) {
                element = ((Identifier)selectedNode).resolveBinding().getPHPElement();
            }
        }
        catch (Exception exception) {}
        if (element == null) {
            try {
                element = sourceModule.getElementAt(offset);
            }
            catch (ModelException modelException) {}
        }
        return element;
    }

    public void run(ITextSelection selection) {
        if (this.lastSelectedElement == null) {
            this.getShell().getDisplay().beep();
            return;
        }
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)true);
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)input)) {
            return;
        }
        this.run(new IModelElement[]{this.lastSelectedElement});
    }

    public void run(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            if (selection.size() != 1) {
                return;
            }
            Object input = selection.getFirstElement();
            if (!(input instanceof ISourceModule)) {
                IStatus status = OpenTypeHierarchyAction.createStatus("A PHP element must be selected.");
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)"Cannot create type hierarchy", (IStatus)status);
                return;
            }
            ISourceModule sourceModule = (ISourceModule)input;
            String fileName = sourceModule.getElementName();
            IModelElement element = DLTKCore.create((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName)));
            if (element instanceof ISourceModule) {
                int offset = 0;
                try {
                    offset = sourceModule.getSourceRange().getOffset();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                IModelElement modelElement = this.getSelectionModelElement(offset, 1, (ISourceModule)element);
                if (modelElement != null) {
                    if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)modelElement)) {
                        return;
                    }
                    this.run(new IModelElement[]{modelElement});
                }
            }
        }
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open((IModelElement[])elements, (IWorkbenchWindow)this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeInHierarchyAction_dialogTitle;
    }

    private static IStatus createStatus(String message) {
        return new Status(1, PHPUiPlugin.getPluginId(), 10001, message, null);
    }

    public void update() {
        this.setEnabled(this.isEnabled(this.getCurrentSelection()));
    }

    protected ITextSelection getCurrentSelection() {
        if (this.fEditor == null) {
            return null;
        }
        ISelectionProvider provider = this.fEditor.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }
}

