/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PHPServerAdvancedTab
extends AbstractLaunchConfigurationTab {
    private Button debugFirstPageBt;
    private Button debugAllPagesBt;
    private Button debugStartFromBt;
    private Button debugContinueBt;
    private Button resetBt;
    private Text debugFromTxt;
    protected Button openBrowser;
    protected boolean isOpenInBrowser;
    protected WidgetListener listener = new WidgetListener();
    protected ILaunchConfiguration launchConfiguration;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createAdvanceControl(composite);
        this.createExtensionControls(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    protected void createAdvanceControl(Composite composite) {
        Group group = new Group(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Session Settings");
        this.openBrowser = new Button((Composite)group, 32);
        this.openBrowser.setText("Open in Browser");
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.openBrowser.setLayoutData((Object)data);
        this.openBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                PHPServerAdvancedTab.this.isOpenInBrowser = b.getSelection();
                if (!PHPServerAdvancedTab.this.isOpenInBrowser) {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(true);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(false);
                } else {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(false);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(true);
                }
                PHPServerAdvancedTab.this.debugStartFromBt.setSelection(false);
                PHPServerAdvancedTab.this.debugContinueBt.setSelection(false);
                PHPServerAdvancedTab.this.enableSessionSettingButtons(PHPServerAdvancedTab.this.isOpenInBrowser);
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.debugAllPagesBt = this.createRadioButton((Composite)group, "Debug &All Pages");
        data = (GridData)this.debugAllPagesBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugFirstPageBt = this.createRadioButton((Composite)group, "Debug &First Page Only");
        data = (GridData)this.debugFirstPageBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 20;
        this.debugStartFromBt = this.createRadioButton((Composite)group, "&Start Debug from:");
        data = (GridData)this.debugStartFromBt.getLayoutData();
        data.horizontalIndent = 20;
        this.debugFromTxt = new Text((Composite)group, 2052);
        data = new GridData(768);
        this.debugFromTxt.setLayoutData((Object)data);
        this.resetBt = this.createPushButton((Composite)group, "Default", null);
        this.resetBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PHPServerAdvancedTab.this.launchConfiguration != null) {
                    try {
                        PHPServerAdvancedTab.this.debugFromTxt.setText(PHPServerAdvancedTab.this.launchConfiguration.getAttribute("base_url", ""));
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.debugContinueBt = this.createCheckButton((Composite)group, "&Continue Debug from This Page");
        data = (GridData)this.debugContinueBt.getLayoutData();
        data.horizontalSpan = 3;
        data.horizontalIndent = 40;
        this.debugStartFromBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPServerAdvancedTab.this.updateDebugFrom();
            }
        });
        this.updateDebugFrom();
        this.debugFirstPageBt.addSelectionListener((SelectionListener)this.listener);
        this.debugAllPagesBt.addSelectionListener((SelectionListener)this.listener);
        this.debugContinueBt.addSelectionListener((SelectionListener)this.listener);
        this.debugStartFromBt.addSelectionListener((SelectionListener)this.listener);
        this.debugFromTxt.addModifyListener((ModifyListener)this.listener);
    }

    private void enableSessionSettingButtons(boolean isOpenInBrowser) {
        String mode = this.getLaunchConfigurationDialog().getMode();
        isOpenInBrowser = isOpenInBrowser && "debug".equals(mode);
        this.debugFirstPageBt.setEnabled(isOpenInBrowser);
        this.debugAllPagesBt.setEnabled(isOpenInBrowser);
        this.debugStartFromBt.setEnabled(isOpenInBrowser);
        this.debugContinueBt.setEnabled(false);
        this.resetBt.setEnabled(false);
        this.debugFromTxt.setEnabled(false);
    }

    protected void createExtensionControls(Composite composite) {
    }

    public String getName() {
        return "Advanced";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        try {
            this.isOpenInBrowser = configuration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowser.setSelection(this.isOpenInBrowser);
            String debugSetting = configuration.getAttribute("debugPages", "debugAllPages");
            if ("debugAllPages".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(true);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFirstPage".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(true);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFrom".equals(debugSetting)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(true);
                boolean shouldContinue = configuration.getAttribute("debugFromURL", false);
                this.debugContinueBt.setSelection(shouldContinue);
            }
            String startFromURL = configuration.getAttribute("debugContinue", "");
            this.debugFromTxt.setText(startFromURL);
            this.updateDebugFrom();
            this.enableSessionSettingButtons(this.isOpenInBrowser);
        }
        catch (CoreException coreException) {}
        this.isValid(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfiguration = configuration;
        configuration.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", this.isOpenInBrowser);
        if (this.isOpenInBrowser) {
            if (this.debugAllPagesBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugAllPages");
            } else if (this.debugFirstPageBt.getSelection()) {
                configuration.setAttribute("debugPages", "debugFirstPage");
            } else {
                configuration.setAttribute("debugPages", "debugFrom");
                configuration.setAttribute("debugContinue", this.debugFromTxt.getText());
                configuration.setAttribute("debugFromURL", this.debugContinueBt.getSelection());
            }
        } else {
            configuration.setAttribute("debugPages", "debugFirstPage");
        }
        this.applyExtension(configuration);
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfiguration = configuration;
        this.setErrorMessage(null);
        configuration.setAttribute("debugPages", "debugAllPages");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.launchConfiguration = launchConfig;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.debugStartFromBt.getSelection()) {
            if (this.debugFromTxt.getText().trim().equals("")) {
                this.setErrorMessage("Invalid debug start page");
                return false;
            }
            try {
                new URL(this.debugFromTxt.getText());
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage("Invalid URL");
                return false;
            }
        }
        return this.isValidExtension(launchConfig);
    }

    protected boolean isValidExtension(ILaunchConfiguration launchConfig) {
        return true;
    }

    private void updateDebugFrom() {
        if (this.launchConfiguration != null && this.debugFromTxt.getText().trim().equals("")) {
            try {
                this.debugFromTxt.setText(this.launchConfiguration.getAttribute("base_url", ""));
            }
            catch (CoreException coreException) {}
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    boolean debugFromSelected = PHPServerAdvancedTab.this.debugStartFromBt.getSelection();
                    PHPServerAdvancedTab.this.debugFromTxt.setEnabled(debugFromSelected);
                    PHPServerAdvancedTab.this.debugContinueBt.setEnabled(debugFromSelected);
                    PHPServerAdvancedTab.this.resetBt.setEnabled(debugFromSelected);
                }
                catch (SWTException sWTException) {}
            }
        });
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            PHPServerAdvancedTab.this.setDirty(true);
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }
    }
}

