/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.PHPBuildPathSourcePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPBuildPathsBlock
extends BuildpathsBlock {
    public PHPBuildPathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        super(runnableContext, context, pageToShow, useNewPage, pageContainer);
    }

    protected IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected boolean supportZips() {
        return false;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        BuildPathComposite container = new BuildPathComposite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData(this.createGridData(1808, 1, 0));
        this.fSourceContainerPage = new PHPBuildPathSourcePage((ListDialogField)this.fBuildPathList);
        ((PHPBuildPathSourcePage)this.fSourceContainerPage).registerRemovedElementListener(container);
        Control control = this.fSourceContainerPage.getControl((Composite)container);
        control.setLayoutData((Object)this.createGridData(1808, 1, 0));
        if (this.fCurrScriptProject != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
        }
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData gd = new GridData(flag);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = hspan;
        return gd;
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.removeEtnries();
        this.adaptIncludePath();
        PHPBuildPathsBlock.flush((List)this.fBuildPathList.getElements(), (IScriptProject)this.getScriptProject(), (IProgressMonitor)monitor);
        super.configureScriptProject(monitor);
    }

    private void removeEtnries() {
        PHPBuildPathSourcePage buildPathSourcePage = (PHPBuildPathSourcePage)this.fSourceContainerPage;
        List<BPListElement> removedElements = buildPathSourcePage.getRemovedElements();
        if (removedElements.size() > 0) {
            for (BPListElement element : removedElements) {
                try {
                    if (!BuildPathUtils.isContainedInBuildpath((IPath)element.getBuildpathEntry().getPath(), (IScriptProject)this.fCurrScriptProject)) continue;
                    BuildPathUtils.removeEntryFromBuildPath((IScriptProject)this.fCurrScriptProject, (IBuildpathEntry)element.getBuildpathEntry());
                }
                catch (ModelException e) {
                    PHPCorePlugin.log((Throwable)e);
                }
            }
        }
    }

    private void adaptIncludePath() {
        PHPBuildPathSourcePage buildPathSourcePage = (PHPBuildPathSourcePage)this.fSourceContainerPage;
        boolean shouldRemoveFromIncludePath = buildPathSourcePage.shouldRemoveFromIncludePath();
        if (!shouldRemoveFromIncludePath) {
            return;
        }
        List<BPListElement> removedElements = buildPathSourcePage.getRemovedElements();
        ArrayList<IBuildpathEntry> buildPathEntries = new ArrayList<IBuildpathEntry>();
        IProject project = this.fCurrScriptProject.getProject();
        if (removedElements.size() > 0) {
            for (BPListElement listElement : removedElements) {
                if (IncludePathManager.isInIncludePath((IProject)this.fCurrScriptProject.getProject(), (IPath)listElement.getPath()) == null) continue;
                buildPathEntries.add(listElement.getBuildpathEntry());
            }
            try {
                for (IBuildpathEntry buildpathEntry : buildPathEntries) {
                    IncludePathManager.getInstance().removeEntryFromIncludePath(project, buildpathEntry);
                }
            }
            catch (ModelException e) {
                Logger.logException((String)"Failed adding entries to build path", (Throwable)e);
            }
        }
    }

    protected void doUpdateUI() {
        this.fBuildPathDialogField.refresh();
        this.fBuildPathList.refresh();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fPathStatus, this.fBuildPathStatus});
    }

    private final class BuildPathComposite
    extends Composite
    implements IElementChangedListener,
    IChangeListener {
        private BuildPathComposite(Composite parent, int style) {
            super(parent, style);
            DLTKCore.addElementChangedListener((IElementChangedListener)this);
        }

        public void dispose() {
            if (PHPBuildPathsBlock.this.fSourceContainerPage instanceof PHPBuildPathSourcePage) {
                PHPBuildPathSourcePage page = (PHPBuildPathSourcePage)PHPBuildPathsBlock.this.fSourceContainerPage;
                page.unregisterRemovedElementListener(this);
            }
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
            super.dispose();
        }

        public void elementChanged(ElementChangedEvent event) {
            PHPBuildPathsBlock.this.updateUI();
        }

        public void update(boolean changed) {
            try {
                PHPBuildPathsBlock.this.configureScriptProject((IProgressMonitor)new NullProgressMonitor());
                PHPBuildPathsBlock.this.updateUI();
            }
            catch (OperationCanceledException e) {
                PHPCorePlugin.log((Throwable)e);
            }
            catch (CoreException e) {
                PHPCorePlugin.log((Throwable)e);
            }
        }
    }
}

