/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.internal.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProjectOutlineGroups {
    GROUP_CLASSES(PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.classes")),
    GROUP_NAMESPACES(PHPPluginImages.DESC_OBJ_PHP_NAMESPACES_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.namespaces")),
    GROUP_CONSTANTS(PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.constants")),
    GROUP_FUNCTIONS(PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.functions"));

    private final Image image;
    private final String text;
    protected static final Object[] NO_CHILDREN;

    static {
        NO_CHILDREN = new Object[0];
    }

    private ProjectOutlineGroups(Image image, String text) {
        this.image = image;
        this.text = text;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    protected Object[] getChildren() {
        if (ProjectOutlineContentProvider.scripProject != null) {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)ProjectOutlineContentProvider.scripProject, (int)1);
            TreeSet<IModelElement> childrenList = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement o1, IModelElement o2) {
                    int res = o1.getElementName().compareTo(o2.getElementName());
                    if (res == 0) {
                        return (String.valueOf(o1.getPath().toOSString()) + o1.getElementName()).compareTo(String.valueOf(o2.getPath().toOSString()) + o2.getElementName());
                    }
                    return res;
                }
            });
            switch (this) {
                case GROUP_NAMESPACES: {
                    childrenList.addAll(Arrays.asList(PHPModelUtils.getAllNamespaces((IDLTKSearchScope)scope)));
                    break;
                }
                case GROUP_CLASSES: {
                    childrenList.addAll(Arrays.asList(PHPModelUtils.getAllClassesAndInterfaces((IDLTKSearchScope)scope)));
                    break;
                }
                case GROUP_FUNCTIONS: {
                    childrenList.addAll(Arrays.asList(PHPModelUtils.getAllFunctions((IDLTKSearchScope)scope)));
                    break;
                }
                case GROUP_CONSTANTS: {
                    IField[] fields;
                    IField[] iFieldArray = fields = PHPModelUtils.getAllFields((IDLTKSearchScope)scope);
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField iField = iFieldArray[n2];
                        try {
                            if (PHPFlags.isConstant((int)iField.getFlags())) {
                                childrenList.add((IModelElement)iField);
                            }
                        }
                        catch (ModelException e) {
                            Logger.logException(e);
                        }
                        ++n2;
                    }
                    break;
                }
            }
            return childrenList.toArray();
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren() {
        Object[] children = this.getChildren();
        return children != null && children.length != 0;
    }
}

