/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.filesystem.FileStoreFactory;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.PHPBreakpointImageDescriptor;
import org.eclipse.php.internal.debug.ui.sourcelookup.PHPSourceNotFoundEditorInput;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class PHPModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private ImageDescriptorRegistry fDebugImageRegistry;

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof PHPConditionalBreakpoint) {
            return this.getBreakpointImage((PHPConditionalBreakpoint)element);
        }
        return null;
    }

    private Image getBreakpointImage(PHPConditionalBreakpoint breakpoint) {
        try {
            if (breakpoint.isConditionEnabled()) {
                PHPBreakpointImageDescriptor descriptor = breakpoint.isEnabled() ? new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), 96) : new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 64);
                return this.getDebugImageRegistry().get((ImageDescriptor)descriptor);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    protected ImageDescriptorRegistry getDebugImageRegistry() {
        if (this.fDebugImageRegistry == null) {
            this.fDebugImageRegistry = PHPDebugUIPlugin.getImageDescriptorRegistry();
        }
        return this.fDebugImageRegistry;
    }

    public String getText(Object element) {
        if (element instanceof PHPDebugTarget) {
            return this.getTargetText((PHPDebugTarget)element);
        }
        if (element instanceof PHPThread) {
            return this.getThreadText((PHPThread)element);
        }
        if (element instanceof PHPStackFrame) {
            return this.getStackFrameText((PHPStackFrame)element);
        }
        if (element instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint breakpoint = (PHPLineBreakpoint)element;
            IMarker marker = breakpoint.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return null;
            }
            if (resource instanceof IWorkspaceRoot) {
                try {
                    String filename = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                    Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
                    return String.valueOf(filename) + " [line: " + lineNumber.toString() + "]";
                }
                catch (CoreException e) {
                    Logger.logException("Unexpected error in PHPModelPresentation", e);
                }
            }
        }
        return null;
    }

    private String getTargetText(PHPDebugTarget target) {
        String label = "";
        if (target.isTerminated()) {
            label = MessageFormat.format((String)PHPDebugUIMessages.MPresentation_Terminated_1, (Object[])new Object[0]);
        }
        return String.valueOf(label) + PHPDebugUIMessages.MPresentation_PHP_APP_1;
    }

    private String getThreadText(PHPThread thread) {
        PHPDebugTarget target = (PHPDebugTarget)thread.getDebugTarget();
        String label = "";
        try {
            label = target.getName();
        }
        catch (DebugException e1) {
            Logger.logException("PHPModelPresentation error getting target name", e1);
        }
        if (thread.isStepping()) {
            label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_Stepping_1;
        } else if (thread.isSuspended()) {
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length == 0) {
                label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_Suspended_1;
            } else {
                IBreakpoint breakpoint = breakpoints[0];
                if (breakpoint instanceof PHPLineBreakpoint) {
                    label = String.valueOf(label) + PHPDebugUIMessages.MPresentation_SLineBreakpoint_1;
                }
            }
        } else if (thread.isTerminated()) {
            label = String.valueOf(PHPDebugUIMessages.MPresentation_Terminated_1) + label;
        }
        return label;
    }

    private String getStackFrameText(PHPStackFrame frame) {
        try {
            StringBuffer buffer = new StringBuffer();
            String frameName = frame.getName();
            if (frameName != null && frameName.length() > 0) {
                buffer.append(frame.getName());
                buffer.append("() ");
            }
            buffer.append(frame.getSourceName());
            buffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + frame.getLineNumber());
            return buffer.toString();
        }
        catch (DebugException e) {
            Logger.logException("Unexpected error in PHPModelPresentation", e);
        }
        catch (NullPointerException npe) {
            StringBuffer errorMessage = new StringBuffer("NPE in getStackFrameText(). Frame = ");
            errorMessage.append(frame);
            if (frame != null) {
                errorMessage.append(", Thread = ");
                errorMessage.append(frame.getThread());
            }
            Logger.logException(errorMessage.toString(), npe);
        }
        return "";
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint breakpoint = (PHPLineBreakpoint)element;
            IMarker marker = breakpoint.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (resource instanceof IWorkspaceRoot) {
                try {
                    String filename = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                    String type = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_Type");
                    if ("org.eclipse.php.debug.core.Include".equals(type)) {
                        String projectName = marker.getAttribute("org.eclipse.php.debug.core.Project", "");
                        IProject project = PHPDebugUIPlugin.getProject(projectName);
                        String includeBaseDir = marker.getAttribute("org.eclipse.php.debug.core.Include_Path_Basedir", "");
                        filename = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", filename);
                        File file = new File(filename);
                        LocalFileStorage lfs = new LocalFileStorage(file);
                        lfs.setProject(project);
                        lfs.setIncBaseDirName(includeBaseDir);
                        return new LocalFileStorageEditorInput(lfs);
                    }
                    if ("org.eclipse.php.debug.core.External".equals(type) || "org.eclipse.php.debug.core.Remote".equals(type)) {
                        File file = new File(filename);
                        return new FileStoreEditorInput(FileStoreFactory.createFileStore((File)file));
                    }
                }
                catch (CoreException e) {
                    Logger.logException("Unexpected error in PHPModelPresentation", e);
                }
            }
        }
        if (element instanceof ZipEntryStorage) {
            return new ZipEntryStorageEditorInput((ZipEntryStorage)element);
        }
        if (element instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((LocalFileStorage)element);
        }
        if (element instanceof PHPSourceNotFoundInput) {
            return new PHPSourceNotFoundEditorInput((PHPSourceNotFoundInput)element);
        }
        if (element instanceof IFileStore) {
            return new FileStoreEditorInput((IFileStore)element);
        }
        Logger.log(202, "Unknown editor input type: " + element.getClass().getName());
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }
}

