/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.template.php;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.template.php.CodeTemplateContextType;

public class CodeTemplateContext
extends TemplateContext {
    private String fLineDelimiter;
    private IScriptProject fProject;

    public CodeTemplateContext(String contextTypeName, IScriptProject sp, String lineDelim) {
        super(CodeTemplateContext.getTemplateContextRegistry().getContextType(contextTypeName));
        this.fLineDelimiter = lineDelim;
        this.fProject = sp;
    }

    protected static ContextTypeRegistry getTemplateContextRegistry() {
        return PHPUiPlugin.getDefault().getTemplateContextRegistry();
    }

    public IScriptProject getJavaProject() {
        return this.fProject;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        Iterator iterator = this.getContextType().resolvers();
        while (iterator.hasNext()) {
            TemplateVariableResolver var = (TemplateVariableResolver)iterator.next();
            if (!(var instanceof CodeTemplateContextType.CodeTemplateVariableResolver)) continue;
            Assert.isNotNull((Object)this.getVariable(var.getType()), (String)("Variable " + var.getType() + "not defined"));
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        String pattern = template.getPattern();
        if (this.fLineDelimiter != null) {
            pattern = CodeTemplateContext.changeLineDelimiter(pattern, this.fLineDelimiter);
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(pattern);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private static String changeLineDelimiter(String code, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                if (i != 0) {
                    buf.append(lineDelim);
                }
                IRegion region = tracker.getLineInformation(i);
                String line = code.substring(region.getOffset(), region.getOffset() + region.getLength());
                buf.append(line);
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return code;
        }
    }

    public boolean canEvaluate(Template template) {
        return true;
    }
}

