/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.ui.IWorkbenchSite;

public class RemoveFromIncludepathAction
extends Action
implements ISelectionChangedListener {
    private List<Object> fSelectedElements;

    public RemoveFromIncludepathAction(IWorkbenchSite site) {
        super("Remove from Include Path", DLTKPluginImages.DESC_ELCL_REMOVE_FROM_BP);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        this.fSelectedElements = new ArrayList<Object>();
    }

    public void run() {
        Object object = this.fSelectedElements.get(0);
        if (object instanceof ExternalProjectFragment) {
            ExternalProjectFragment projFragment = (ExternalProjectFragment)object;
            IScriptProject scriptProject = projFragment.getScriptProject();
            try {
                BuildPathUtils.removeEntryFromBuildPath((IScriptProject)scriptProject, (IBuildpathEntry)projFragment.getBuildpathEntry());
            }
            catch (ModelException e) {
                Logger.logException("Could not remove buildPathEntry", e);
            }
        } else if (object instanceof IProjectFragment) {
            IProjectFragment cfr_ignored_0 = (IProjectFragment)object;
        } else {
            assert (object instanceof IncludePath);
            IncludePath includePath = (IncludePath)object;
            try {
                if (includePath.isBuildpath()) {
                    IncludePathManager.getInstance().removeEntryFromIncludePath(includePath.getProject(), (IBuildpathEntry)includePath.getEntry());
                } else {
                    IProject proj = includePath.getProject();
                    IncludePathManager manager = IncludePathManager.getInstance();
                    IncludePath[] paths = manager.getIncludePaths(proj);
                    ArrayList<IncludePath> entries = new ArrayList<IncludePath>();
                    IncludePath[] includePathArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IncludePath path = includePathArray[n2];
                        if (!path.equals((Object)includePath)) {
                            entries.add(path);
                        }
                        ++n2;
                    }
                    manager.setIncludePath(proj, entries.toArray(new IncludePath[entries.size()]));
                }
            }
            catch (ModelException e) {
                Logger.logException("Could not remove buildPathEntry", e);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                this.fSelectedElements.add(element);
                if (!(element instanceof IProjectFragment || element instanceof IScriptProject || element instanceof IncludePath)) {
                    return false;
                }
                if (element instanceof IScriptProject) {
                    IScriptProject project = (IScriptProject)element;
                    if (BuildpathModifier.isSourceFolder((IScriptProject)project)) continue;
                    return false;
                }
                if (element instanceof IProjectFragment) {
                    IBuildpathEntry entry = ((IProjectFragment)element).getRawBuildpathEntry();
                    if (entry == null || entry.getEntryKind() != 5) continue;
                    return false;
                }
                if (element instanceof IncludePath) break;
            }
            return true;
        }
        catch (ModelException modelException) {
            return false;
        }
    }
}

