/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.swt.widgets.Shell;

public class IncludePathUtils {
    public static boolean fPrompting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openConfirmationDialog(Shell shell, String title, String message) {
        if (shell == null || fPrompting) {
            return false;
        }
        fPrompting = true;
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        boolean answer = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
        Class<IncludePathUtils> clazz = IncludePathUtils.class;
        synchronized (IncludePathUtils.class) {
            fPrompting = false;
            IncludePathUtils.class.notifyAll();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return answer;
        }
    }

    private static IPath getRelativeLocationFromIncludePath(IScriptProject project, IPath path) {
        IPath inIncludePath = IncludePathManager.isInIncludePath((IProject)project.getProject(), (IPath)path);
        if (inIncludePath != null) {
            return path.makeRelativeTo(inIncludePath);
        }
        return Path.EMPTY;
    }

    public static IPath getRelativeLocationFromIncludePath(IScriptProject project, IModelElement modelElement) {
        if (modelElement.getResource() != null) {
            return IncludePathUtils.getRelativeLocationFromIncludePath(project, modelElement.getPath());
        }
        IScriptProject elementProject = modelElement.getScriptProject();
        if (elementProject != null && !elementProject.equals(project)) {
            return Path.EMPTY;
        }
        ISourceModule sourceModule = (ISourceModule)modelElement.getAncestor(5);
        IScriptFolder folder = (IScriptFolder)modelElement.getAncestor(4);
        if (sourceModule != null && folder != null) {
            StringBuilder sb = new StringBuilder(folder.getElementName());
            sb.append("/");
            sb.append(sourceModule.getElementName());
            return new Path(sb.toString());
        }
        return Path.EMPTY;
    }
}

