/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.debug.core.Logger;

public class PHPDirectorySourceContainer
extends DirectorySourceContainer {
    private IProject project;

    public PHPDirectorySourceContainer(File dir, boolean subfolders, IProject project) {
        super(dir, subfolders);
        this.project = project;
    }

    public PHPDirectorySourceContainer(IPath dirPath, boolean subfolders) {
        super(dirPath.toFile(), subfolders);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File file = new File(name);
        if (file.exists() && !file.isDirectory()) {
            return this.processObjects(new Object[]{new LocalFileStorage(file)});
        }
        Object[] lFileStorage = super.findSourceElements(name);
        return this.processObjects(lFileStorage);
    }

    protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
        Object[] lFileStorage = super.findSourceElements(name, containers);
        return this.processObjects(lFileStorage);
    }

    public String getName() {
        return super.getName();
    }

    public ISourceContainerType getType() {
        return null;
    }

    private Object[] processObjects(Object[] lFileStorage) {
        Object[] storage = new Object[lFileStorage.length];
        int i = 0;
        while (i < lFileStorage.length) {
            if (lFileStorage[i] instanceof org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage) {
                org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage lsEntry = (org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage)lFileStorage[i];
                LocalFileStorage lStorage = new LocalFileStorage(lsEntry.getFile());
                lStorage.setProject(this.project);
                try {
                    lStorage.setIncBaseDirName(this.getDirectory().getCanonicalPath());
                }
                catch (IOException e) {
                    Logger.logException("Unexpected error in PHPDirectorySourceContainer", e);
                }
                storage[i] = lStorage;
            } else if (lFileStorage[i] instanceof ZipEntryStorage) {
                ZipEntryStorage zipEntry = (ZipEntryStorage)lFileStorage[i];
                org.eclipse.php.internal.core.containers.ZipEntryStorage zStorage = new org.eclipse.php.internal.core.containers.ZipEntryStorage(zipEntry.getArchive(), zipEntry.getZipEntry());
                zStorage.setProject(this.project);
                storage[i] = zStorage;
            } else {
                storage[i] = lFileStorage[i];
            }
            ++i;
        }
        return storage;
    }
}

