/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.viewsupport;

import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.corext.util.Strings;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class BindingLabelProvider
extends LabelProvider {
    public static final long DEFAULT_TEXTFLAGS = ScriptElementLabels.ALL_DEFAULT;
    public static final int DEFAULT_IMAGEFLAGS = 1;
    private final long fTextFlags;
    private final int fImageFlags;
    private ImageDescriptorRegistry fRegistry;

    private static int getAdornmentFlags(IBinding binding) {
        int modifiers;
        int adornments = 0;
        if (binding instanceof IMethodBinding && ((IMethodBinding)binding).isConstructor()) {
            adornments |= 0x200;
        }
        if (PHPFlags.isAbstract((int)(modifiers = binding.getModifiers()))) {
            adornments |= 4;
        }
        if (PHPFlags.isFinal((int)modifiers)) {
            adornments |= 8;
        }
        if (PHPFlags.isStatic((int)modifiers)) {
            adornments |= 1;
        }
        if (binding.isDeprecated()) {
            adornments |= 0x400;
        }
        return adornments;
    }

    private static ImageDescriptor getBaseImageDescriptor(IBinding binding, int flags) {
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            if (typeBinding.isArray()) {
                typeBinding = typeBinding.getElementType();
            }
            return BindingLabelProvider.getTypeImageDescriptor(false, typeBinding, flags);
        }
        if (binding instanceof IMethodBinding) {
            return BindingLabelProvider.getMethodImageDescriptor(binding.getModifiers());
        }
        if (binding instanceof IVariableBinding) {
            return BindingLabelProvider.getFieldImageDescriptor((IVariableBinding)binding);
        }
        return DLTKPluginImages.DESC_OBJS_UNKNOWN;
    }

    private static ImageDescriptor getClassImageDescriptor(int modifiers) {
        return DLTKPluginImages.DESC_OBJS_CLASS;
    }

    private static ImageDescriptor getFieldImageDescriptor(IVariableBinding binding) {
        int modifiers = binding.getModifiers();
        if (PHPFlags.isPublic((int)modifiers)) {
            return DLTKPluginImages.DESC_FIELD_PUBLIC;
        }
        if (PHPFlags.isProtected((int)modifiers)) {
            return DLTKPluginImages.DESC_FIELD_PROTECTED;
        }
        if (PHPFlags.isPrivate((int)modifiers)) {
            return DLTKPluginImages.DESC_FIELD_PRIVATE;
        }
        return DLTKPluginImages.DESC_FIELD_DEFAULT;
    }

    private static void getFieldLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding declaringClass;
        if ((flags & 0x8000L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x20000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            buffer.append(" - ");
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static void getLocalVariableLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        IFunctionBinding declaringMethod;
        if ((flags & 0x8000L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringMethod = binding.getDeclaringFunction()) != null) {
            BindingLabelProvider.getMethodLabel(declaringMethod, flags, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int modifiers) {
        return DLTKPluginImages.DESC_OBJS_INTERFACE;
    }

    private static ImageDescriptor getMethodImageDescriptor(int modifiers) {
        if (PHPFlags.isPublic((int)modifiers)) {
            return DLTKPluginImages.DESC_METHOD_PUBLIC;
        }
        if (PHPFlags.isProtected((int)modifiers)) {
            return DLTKPluginImages.DESC_METHOD_PROTECTED;
        }
        if (PHPFlags.isPrivate((int)modifiers)) {
            return DLTKPluginImages.DESC_METHOD_PRIVATE;
        }
        return DLTKPluginImages.DESC_METHOD_DEFAULT;
    }

    private static void appendDimensions(int dim, StringBuffer buffer) {
        int i = 0;
        while (i < dim) {
            buffer.append('[').append(']');
            ++i;
        }
    }

    private static void getMethodLabel(IFunctionBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding[] typeParameters;
        ITypeBinding[] exceptions;
        int index;
        IMethodBinding methodBinding;
        IMethodBinding iMethodBinding = methodBinding = binding instanceof IMethodBinding ? (IMethodBinding)binding : null;
        if (!((flags & 0x40L) == 0L || methodBinding != null && methodBinding.isConstructor())) {
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x80L) != 0L && methodBinding != null) {
            BindingLabelProvider.getTypeLabel(methodBinding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        buffer.append('(');
        if ((flags & 1L | 2L) != 0L) {
            ITypeBinding[] parameters;
            ITypeBinding[] iTypeBindingArray = parameters = (flags & 1L) != 0L ? binding.getParameterTypes() : null;
            if (parameters != null) {
                index = 0;
                while (index < parameters.length) {
                    if (index > 0) {
                        buffer.append(", ");
                    }
                    ITypeBinding paramType = parameters[index];
                    if (binding.isVarargs() && index == parameters.length - 1) {
                        BindingLabelProvider.getTypeLabel(paramType.getElementType(), flags & 0x200000L, buffer);
                        BindingLabelProvider.appendDimensions(paramType.getDimensions() - 1, buffer);
                        buffer.append("...");
                    } else {
                        BindingLabelProvider.getTypeLabel(paramType, flags & 0x200000L, buffer);
                    }
                    ++index;
                }
            }
        } else if (binding.getParameterTypes().length > 0) {
            buffer.append("...");
        }
        buffer.append(')');
        if ((flags & 0x10L) != 0L && (exceptions = binding.getExceptionTypes()).length > 0) {
            buffer.append(" throws ");
            index = 0;
            while (index < exceptions.length) {
                if (index > 0) {
                    buffer.append(", ");
                }
                BindingLabelProvider.getTypeLabel(exceptions[index], flags & 0x200000L, buffer);
                ++index;
            }
        }
        if ((flags & 8L) != 0L && (typeParameters = binding.getParameterTypes()).length > 0) {
            buffer.append(' ');
            BindingLabelProvider.getTypeParametersLabel(typeParameters, buffer);
        }
        if (!((flags & 0x20L) == 0L || methodBinding != null && methodBinding.isConstructor())) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x100L) != 0L && methodBinding != null) {
            buffer.append(" - ");
            BindingLabelProvider.getTypeLabel(methodBinding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static ImageDescriptor getTypeImageDescriptor(boolean inner, ITypeBinding binding, int flags) {
        if (binding.isInterface()) {
            if ((flags & 4) != 0) {
                return DLTKPluginImages.DESC_OBJS_INTERFACEALT;
            }
            return BindingLabelProvider.getInterfaceImageDescriptor(binding.getModifiers());
        }
        if (binding.isClass()) {
            if ((flags & 4) != 0) {
                return DLTKPluginImages.DESC_OBJS_CLASSALT;
            }
            return BindingLabelProvider.getClassImageDescriptor(binding.getModifiers());
        }
        return null;
    }

    private static void getTypeLabel(ITypeBinding binding, long flags, StringBuffer buffer) {
        if (binding.isArray()) {
            BindingLabelProvider.getTypeLabel(binding.getElementType(), flags & 0x200000L, buffer);
            BindingLabelProvider.appendDimensions(binding.getDimensions(), buffer);
        } else {
            String name = binding.getName();
            if (name != null) {
                buffer.append(name);
            }
        }
    }

    private static void getTypeParametersLabel(ITypeBinding[] typeParameters, StringBuffer buffer) {
        if (typeParameters.length > 0) {
            buffer.append('<');
            int index = 0;
            while (index < typeParameters.length) {
                if (index > 0) {
                    buffer.append(", ");
                }
                buffer.append(typeParameters[index].getName());
                ++index;
            }
            buffer.append('>');
        }
    }

    public static String getBindingLabel(IBinding binding, long flags) {
        StringBuffer buffer = new StringBuffer(60);
        if (binding instanceof ITypeBinding) {
            BindingLabelProvider.getTypeLabel((ITypeBinding)binding, flags, buffer);
        } else if (binding instanceof IMethodBinding) {
            BindingLabelProvider.getMethodLabel((IFunctionBinding)((IMethodBinding)binding), flags, buffer);
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (variable.isField()) {
                BindingLabelProvider.getFieldLabel(variable, flags, buffer);
            } else {
                BindingLabelProvider.getLocalVariableLabel(variable, flags, buffer);
            }
        }
        return Strings.markLTR(buffer.toString());
    }

    public static ImageDescriptor getBindingImageDescriptor(IBinding binding, int imageFlags) {
        ImageDescriptor baseImage = BindingLabelProvider.getBaseImageDescriptor(binding, imageFlags);
        if (baseImage != null) {
            int adornmentFlags = BindingLabelProvider.getAdornmentFlags(binding);
            Point size = (imageFlags & 2) != 0 ? ScriptElementImageProvider.SMALL_SIZE : ScriptElementImageProvider.BIG_SIZE;
            return new PHPElementImageDescriptor(baseImage, adornmentFlags, size);
        }
        return null;
    }

    public BindingLabelProvider() {
        this(DEFAULT_TEXTFLAGS, 1);
    }

    public BindingLabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
        this.fRegistry = null;
    }

    public Image getImage(Object element) {
        ImageDescriptor baseImage;
        if (element instanceof IBinding && (baseImage = BindingLabelProvider.getBindingImageDescriptor((IBinding)element, this.fImageFlags)) != null) {
            return this.getRegistry().get(baseImage);
        }
        return super.getImage(element);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String getText(Object element) {
        if (element instanceof IBinding) {
            return BindingLabelProvider.getBindingLabel((IBinding)element, this.fTextFlags);
        }
        return super.getText(element);
    }
}

