/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.watch;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org.eclipse.php.internal.debug.ui.Logger;

public class PHPWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String fExpressionText;
    private IWatchExpressionListener fListener;
    private PHPDebugTarget debugTarget;
    private Job fRunDispatch;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fExpressionText = expression;
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException e) {
                Logger.logException(e);
            }
        }
        if (frame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IDebugTarget target = frame.getDebugTarget();
            if (target instanceof PHPDebugTarget) {
                this.debugTarget = (PHPDebugTarget)target;
                this.fRunDispatch = new EvaluationRunnable();
                this.fRunDispatch.schedule();
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    protected Expression getExpression(PHPDebugTarget debugTarget, String variable) {
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression expression = expressionManager.buildExpression(variable);
        debugTarget.getExpressionManager().getExpressionValue(expression, 1);
        expressionManager.update(expression, 1);
        return expression;
    }

    private final class EvaluationRunnable
    extends Job {
        public EvaluationRunnable() {
            super("EvaluationRunnable");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IWatchExpressionResult watchResult = new IWatchExpressionResult(){

                    public IValue getValue() {
                        Expression value = PHPWatchExpressionDelegate.this.getExpression(PHPWatchExpressionDelegate.this.debugTarget, PHPWatchExpressionDelegate.this.fExpressionText);
                        PHPValue iValue = new PHPValue(PHPWatchExpressionDelegate.this.debugTarget, value);
                        return iValue;
                    }

                    public boolean hasErrors() {
                        return false;
                    }

                    public String[] getErrorMessages() {
                        return null;
                    }

                    public String getExpressionText() {
                        return PHPWatchExpressionDelegate.this.fExpressionText;
                    }

                    public DebugException getException() {
                        return null;
                    }
                };
                PHPWatchExpressionDelegate.this.fListener.watchEvaluationFinished(watchResult);
            }
            catch (Exception e) {
                Logger.logException(e);
                PHPWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
            }
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)PHPWatchExpressionDelegate.this, 2, 128)});
            return Status.OK_STATUS;
        }
    }
}

