/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServerCompositeFragment;
import org.eclipse.php.internal.ui.wizards.CompositeWizardFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.IWizardHandle;
import org.eclipse.php.internal.ui.wizards.WizardControlWrapper;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.swt.widgets.Composite;

public class ServerWizardFragment
extends CompositeWizardFragment {
    private ServerCompositeFragment comp;

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new ServerCompositeFragment(parent, (IControlHandler)new WizardControlWrapper(wizard), false);
        return this.comp;
    }

    public Composite getComposite() {
        return this.comp;
    }

    public void enter() {
        if (this.comp != null) {
            try {
                Server server = (Server)this.getWizardModel().getObject("server");
                if (server == null) {
                    server = new Server();
                    this.comp.setData(server);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        } else {
            Logger.log(4, "Could not display the Servers wizard (component is null).");
        }
    }

    public boolean isComplete() {
        if (this.comp == null) {
            return super.isComplete();
        }
        return super.isComplete() && this.comp.isComplete();
    }

    public void exit() {
        if (this.comp != null) {
            WizardModel model = this.getWizardModel();
            model.putObject("server", (Object)this.comp.getServer());
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        if (this.comp != null) {
            this.comp.performOk();
        }
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        super.performCancel(monitor);
        if (this.getWizardModel().getObject("server") != null) {
            this.getWizardModel().putObject("server", null);
            ServersManager.save();
        }
    }
}

