/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposalCollector;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContentAssistInvocationContext;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateCompletionProcessor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPCompletionProposalComputer
extends ScriptCompletionProposalComputer {
    private String fErrorMessage;

    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        return new PhpTemplateCompletionProcessor(context);
    }

    protected ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext context) {
        boolean explicit = false;
        if (context instanceof PHPContentAssistInvocationContext) {
            explicit = ((PHPContentAssistInvocationContext)context).isExplicit();
        }
        return new PHPCompletionProposalCollector(context.getDocument(), context.getSourceModule(), explicit);
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        IDocument document = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            while (offset > 0) {
                if (document.getChar(offset) == '(') {
                    return offset;
                }
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {}
        return super.guessContextInformationPosition(context);
    }

    protected List computeScriptCompletionProposals(int offset, final ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        ISourceModule sourceModule = context.getSourceModule();
        if (sourceModule == null) {
            return Collections.EMPTY_LIST;
        }
        final ScriptCompletionProposalCollector collector = this.createCollector(context);
        if (collector == null) {
            return Collections.EMPTY_LIST;
        }
        collector.setInvocationContext(context);
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                Point selection = context.getViewer().getSelectedRange();
                if (selection.y > 0) {
                    collector.setReplacementLength(selection.y);
                }
            }
        });
        try {
            sourceModule.codeComplete(offset, (CompletionRequestor)collector);
        }
        catch (ModelException e) {
            this.handleCodeCompletionException(e, context);
        }
        IScriptCompletionProposal[] proposals = collector.getScriptCompletionProposals();
        if (proposals.length == 0) {
            String error = collector.getErrorMessage();
            if (error.length() > 0) {
                this.fErrorMessage = error;
            }
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(proposals);
    }

    protected List computeTemplateCompletionProposals(final int offset, final ScriptContentAssistInvocationContext context, final IProgressMonitor monitor) {
        final List[] result = new List[1];
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                result[0] = PHPCompletionProposalComputer.super.computeTemplateCompletionProposals(offset, context, monitor);
            }
        });
        return result[0];
    }

    private void handleCodeCompletionException(ModelException e, ScriptContentAssistInvocationContext context) {
        ISourceModule module = context.getSourceModule();
        Shell shell = context.getViewer().getTextWidget().getShell();
        if (e.isDoesNotExist() && !module.getScriptProject().isOnBuildpath((IModelElement)module)) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean value = store.getBoolean("org.eclipse.dltk.ui.notification.not_on_buildpath");
            if (!value) {
                MessageDialog.openInformation((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            store.setValue("org.eclipse.dltk.ui.notification.not_on_buildpath", true);
        } else {
            ErrorDialog.openError((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_accessing_title, (String)ScriptTextMessages.CompletionProcessor_error_accessing_message, (IStatus)e.getStatus());
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
        super.sessionEnded();
        this.fErrorMessage = null;
    }
}

