/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.corext.codemanipulation.StubUtility;
import org.eclipse.php.ui.editor.SharedASTProvider;

public class CodeGeneration {
    public static final String CLASS_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.classbody";
    public static final String INTERFACE_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody";
    public static final String ENUM_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody";
    public static final String ANNOTATION_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody";
    private static final String[] EMPTY = new String[0];

    private CodeGeneration() {
    }

    public static String getCompilationUnitContent(IScriptProject sp, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return CodeGeneration.getCompilationUnitContent(sp, CodeGeneration.getFileComment(sp, lineDelimiter), typeComment, typeContent, lineDelimiter);
    }

    public static String getCompilationUnitContent(IScriptProject sp, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return StubUtility.getCompilationUnitContent(sp, fileComment, typeComment, typeContent, lineDelimiter);
    }

    public static String getFileComment(IScriptProject sp, String lineDelimiter) throws CoreException {
        return StubUtility.getFileComment(sp, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, EMPTY, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String[] typeParameterNames, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, typeParameterNames, lineDelimiter);
    }

    public static String getTypeBody(String typeKind, IScriptProject sp, String typeName, String lineDelim) throws CoreException {
        return StubUtility.getTypeBody(typeKind, sp, typeName, lineDelim);
    }

    public static String getFieldComment(IScriptProject sp, IField field, String lineDelimiter) throws CoreException {
        String fieldName = field.getElementName();
        String fieldType = null;
        Boolean isVar = false;
        try {
            Program program = SharedASTProvider.getAST(field.getSourceModule(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            ASTNode elementAt = program.getElementAt(field.getSourceRange().getOffset());
            ITypeBinding varType = null;
            IVariableBinding resolvedBinding = null;
            if (elementAt instanceof FieldsDeclaration) {
                FieldsDeclaration fieldDeclaration = (FieldsDeclaration)elementAt;
                resolvedBinding = fieldDeclaration.resolveTypeBinding();
                if (resolvedBinding != null) {
                    varType = resolvedBinding.getType();
                }
            } else if (elementAt instanceof Variable) {
                isVar = true;
                Variable varDeclaration = (Variable)elementAt;
                if (varDeclaration.getParent() instanceof Assignment) {
                    Expression expression = ((Assignment)varDeclaration.getParent()).getRightHandSide();
                    varType = expression.resolveTypeBinding();
                    if (expression instanceof Scalar) {
                        Scalar scalar = (Scalar)expression;
                        switch (scalar.getScalarType()) {
                            case 0: {
                                fieldType = "integer";
                                break;
                            }
                            case 2: {
                                fieldType = "string";
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    varType = varDeclaration.resolveTypeBinding();
                }
            }
            if (fieldType == null && varType != null) {
                fieldType = varType.isAmbiguous() ? "Ambiguous" : varType.getName();
            }
            if (fieldType == null) {
                fieldType = "unknown_type";
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (isVar.booleanValue()) {
            return StubUtility.getVarComment(sp, fieldType, fieldName, lineDelimiter);
        }
        return StubUtility.getFieldComment(sp, fieldType, fieldName, lineDelimiter);
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, EMPTY, overridden, false, lineDelimiter);
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String[] typeParameterNames, IMethod overridden, String lineDelimiter) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, typeParameterNames, overridden, false, lineDelimiter);
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = "unknown_type";
        String[] typeParameterNames = null;
        String[] parameterTypes = null;
        try {
            Program program = SharedASTProvider.getAST(method.getSourceModule(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            ASTNode elementAt = program.getElementAt(method.getSourceRange().getOffset());
            ITypeBinding returnType = null;
            ITypeBinding[] typeParametersTypes = null;
            IMethodBinding resolvedBinding = null;
            List formalParameters = null;
            if (elementAt instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)elementAt;
                resolvedBinding = methodDeclaration.resolveMethodBinding();
                formalParameters = methodDeclaration.getFunction().formalParameters();
            } else if (elementAt instanceof FunctionDeclaration) {
                FunctionDeclaration functionDeclaration = (FunctionDeclaration)elementAt;
                resolvedBinding = functionDeclaration.resolveFunctionBinding();
                formalParameters = functionDeclaration.formalParameters();
            }
            if (formalParameters != null) {
                parameterTypes = new String[formalParameters.size()];
                int i = 0;
                for (ASTNode node : formalParameters) {
                    FormalParameter formalParameter = (FormalParameter)node;
                    Expression parameterType = formalParameter.getParameterType();
                    if (parameterType != null) {
                        String typeName = ((Identifier)parameterType).getName();
                        parameterTypes[i++] = typeName;
                        continue;
                    }
                    parameterTypes[i++] = null;
                }
            }
            if (resolvedBinding != null) {
                returnType = resolvedBinding.getReturnType();
                if (returnType != null) {
                    retType = returnType.isUnknown() ? "unknown_type" : (returnType.isAmbiguous() ? "Ambiguous" : returnType.getName());
                }
                typeParametersTypes = resolvedBinding.getParameterTypes();
                if (returnType != null) {
                    int i = 0;
                    typeParameterNames = new String[typeParametersTypes.length];
                    ITypeBinding[] iTypeBindingArray = typeParametersTypes;
                    int n = typeParametersTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding type = iTypeBindingArray[n2];
                        typeParameterNames[i++] = type.getName();
                        ++n2;
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        String[] paramNames = method.getParameters();
        int i = 0;
        while (i < paramNames.length) {
            if (parameterTypes != null && parameterTypes[i] != null) {
                paramNames[i] = String.valueOf(parameterTypes[i]) + " " + paramNames[i];
            }
            ++i;
        }
        IType declaringType = method.getDeclaringType();
        if (declaringType != null) {
            return StubUtility.getMethodComment(method.getScriptProject(), declaringType.getElementName(), method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter);
        }
        return StubUtility.getMethodComment(method.getScriptProject(), null, method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter);
    }

    public static String getMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, boolean isConstructor, String bodyStatement, String lineDelimiter) throws CoreException {
        return StubUtility.getMethodBodyContent(isConstructor, sp, declaringTypeName, methodName, bodyStatement, lineDelimiter);
    }

    public static String getGetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, lineDelimiter);
    }

    public static String getSetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, paramName, lineDelimiter);
    }

    public static String getGetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, bareFieldName, lineDelimiter);
    }

    public static String getSetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, paramName, bareFieldName, lineDelimiter);
    }
}

