/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CodeRefactoringUtil {
    public static RefactoringStatus checkMethodSyntaxErrors(int selectionStart, int selectionLength, CompilationUnit cuNode, String invalidSelectionMessage) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(selectionStart, selectionLength), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode coveringNode = analyzer.getLastCoveringNode();
        if (!(coveringNode instanceof Block) || !(coveringNode.getParent() instanceof MethodDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        if (ASTNodes.getMessages(coveringNode, 0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        MethodDeclaration methodDecl = (MethodDeclaration)coveringNode.getParent();
        Object[] keys = new String[]{methodDecl.getName().getIdentifier()};
        String message = Messages.format(RefactoringCoreMessages.CodeRefactoringUtil_error_message, keys);
        return RefactoringStatus.createFatalErrorStatus((String)message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getIndentationLevel(ASTNode node, ICompilationUnit unit) throws CoreException {
        int n;
        IPath fullPath = unit.getCorrespondingResource().getFullPath();
        try {
            FileBuffers.getTextFileBufferManager().connect(fullPath, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(fullPath);
            try {
                IRegion region = buffer.getDocument().getLineInformationOfOffset(node.getStartPosition());
                n = Strings.computeIndentUnits(buffer.getDocument().get(region.getOffset(), region.getLength()), unit.getJavaProject());
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
                Object var5_8 = null;
                FileBuffers.getTextFileBufferManager().disconnect(fullPath, (IProgressMonitor)new NullProgressMonitor());
                return 0;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            FileBuffers.getTextFileBufferManager().disconnect(fullPath, (IProgressMonitor)new NullProgressMonitor());
            throw throwable;
        }
        FileBuffers.getTextFileBufferManager().disconnect(fullPath, (IProgressMonitor)new NullProgressMonitor());
        return n;
    }

    private CodeRefactoringUtil() {
    }
}

