/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.common.MergeUtils;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;

public class SkeletonMergeCommand
extends AbstractDataModelOperation {
    private String[] urls_;
    private String projectName_;

    public SkeletonMergeCommand(String projectName) {
        this.projectName_ = projectName;
    }

    public void setUrls(String[] urls) {
        this.urls_ = urls;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
        PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
        if (mergeContext.isSkeletonMergeEnabled()) {
            ByteArrayInputStream inStream = null;
            if (this.urls_ != null) {
                int i = 0;
                while (i < this.urls_.length) {
                    String mergedContent;
                    String filename = MergeUtils.getFileFromURL((String)this.urls_[i]);
                    if (filename != null && (mergedContent = MergeUtils.mergeFile((String)filename)) != null) {
                        Path targetPath = new Path(filename);
                        IProject project = ProjectUtilities.getProject((String)this.projectName_);
                        byte[] buf = null;
                        if (project != null) {
                            try {
                                buf = mergedContent.getBytes(project.getDefaultCharset());
                            }
                            catch (Throwable throwable) {
                                buf = mergedContent.getBytes();
                            }
                        } else {
                            buf = mergedContent.getBytes();
                        }
                        if ((inStream = new ByteArrayInputStream(buf)) != null) {
                            try {
                                FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath.makeAbsolute(), (InputStream)inStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
                            }
                            catch (CoreException e) {
                                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_FILE_MERGE, (Object[])this.urls_), (Throwable)e);
                                environment.getStatusHandler().reportError(status);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return status;
    }
}

